/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.appwithinminutes.test.po;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.xwiki.appwithinminutes.test.po.ApplicationClassEditPage;
import org.xwiki.test.ui.po.ConfirmationPage;
import org.xwiki.test.ui.po.LiveTableElement;

public class ApplicationsLiveTableElement
extends LiveTableElement {
    private static final String APP_NAME_FILTER_ID = "xwiki-livetable-livetable-filter-1";
    private static final String APP_NAME_COLUMN_TITLE = "Application name";

    public ApplicationsLiveTableElement() {
        super("livetable");
    }

    public boolean isApplicationListed(String appName) {
        return this.hasRow(APP_NAME_COLUMN_TITLE, appName);
    }

    public ConfirmationPage clickDeleteApplication(String appName) {
        this.clickAction(appName, "delete");
        return new ConfirmationPage();
    }

    public boolean canDeleteApplication(String appName) {
        return this.hasAction(appName, "delete");
    }

    public ApplicationClassEditPage clickEditApplication(String appName) {
        this.clickAction(appName, "edit");
        return new ApplicationClassEditPage();
    }

    public boolean canEditApplication(String appName) {
        return this.hasAction(appName, "edit");
    }

    protected void clickAction(String appName, String action) {
        String escapedAppName = appName.replace("\\", "\\\\").replace("'", "\\'");
        String actionLinkXPath = "//tr[td[contains(@class, 'doc_space') and . = '" + escapedAppName + "']]/td[@class = 'actions']//a[contains(@class, 'action" + action + "')]";
        WebElement liveTableBody = this.getDriver().findElement(By.id((String)"livetable-display"));
        liveTableBody.findElement(By.xpath((String)actionLinkXPath)).click();
    }

    protected boolean hasAction(String appName, String action) {
        String escapedAppName = appName.replace("\\", "\\\\").replace("'", "\\'");
        String actionLinkXPath = "//tr[td[contains(@class, 'doc_space') and . = '" + escapedAppName + "']]/td[@class = 'actions']//a[contains(@class, 'action" + action + "')]";
        WebElement liveTableBody = this.getDriver().findElement(By.id((String)"livetable-display"));
        return liveTableBody.findElements(By.xpath((String)actionLinkXPath)).size() > 0;
    }

    public void filterApplicationName(String appNameFilter) {
        super.filterColumn(APP_NAME_FILTER_ID, appNameFilter);
    }

    public String getApplicationNameFilter() {
        return super.getFilterValue(APP_NAME_FILTER_ID);
    }
}

