/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.blog.test.po;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.xwiki.blog.test.po.BlogPostViewPage;
import org.xwiki.test.ui.po.InlinePage;
import org.xwiki.test.ui.po.editor.wysiwyg.EditorElement;
import org.xwiki.test.ui.po.editor.wysiwyg.RichTextAreaElement;

public class BlogPostInlinePage
extends InlinePage {
    @FindBy(id="Blog.BlogPostClass_0_title")
    private WebElement titleInput;
    @FindBy(className="blog-categories-list")
    private WebElement categoryList;
    @FindBy(id="Blog.BlogPostClass_0_hidden")
    private WebElement hiddenCheckBox;
    private final EditorElement contentEditor = new EditorElement("Blog.BlogPostClass_0_content");
    private final EditorElement summaryEditor = new EditorElement("Blog.BlogPostClass_0_extract");

    public void setTitle(String title) {
        this.titleInput.clear();
        this.titleInput.sendKeys(new CharSequence[]{title});
    }

    public String getTitle() {
        return this.titleInput.getAttribute("value");
    }

    public void setContent(String content) {
        RichTextAreaElement richTextArea = this.contentEditor.getRichTextArea();
        richTextArea.clear();
        richTextArea.sendKeys(new CharSequence[]{content});
    }

    public String getContent() {
        return this.contentEditor.getRichTextArea().getText();
    }

    public void setCategories(List<String> categories) {
        for (String categoryName : categories) {
            String categoryReference = categoryName;
            if (categoryReference.indexOf(46) < 0) {
                categoryReference = "Blog." + categoryName;
            }
            String categoryXPath = "//input[@name = 'Blog.BlogPostClass_0_category' and @value = '" + categoryReference + "']";
            for (WebElement category : this.categoryList.findElements(By.xpath((String)categoryXPath))) {
                if (category.isSelected()) continue;
                category.click();
            }
        }
    }

    public List<String> getCategories() {
        ArrayList<String> categories = new ArrayList<String>();
        for (WebElement category : this.categoryList.findElements(By.xpath((String)"//input[@name = 'Blog.BlogPostClass_0_category']"))) {
            if (!category.isSelected()) continue;
            categories.add(StringUtils.substringAfter((String)category.getAttribute("value"), (String)"."));
        }
        return categories;
    }

    public boolean isPublished() {
        Iterator i$ = this.getDriver().findElements(By.id((String)"Blog.BlogPostClass_0_published")).iterator();
        if (i$.hasNext()) {
            WebElement publishCheckBox = (WebElement)i$.next();
            return publishCheckBox.isSelected();
        }
        return true;
    }

    public void setPublished(boolean published) {
        for (WebElement publishCheckBox : this.getDriver().findElements(By.id((String)"Blog.BlogPostClass_0_published"))) {
            if (publishCheckBox.isSelected() == published) continue;
            publishCheckBox.click();
        }
    }

    public boolean isHidden() {
        return this.hiddenCheckBox.isSelected();
    }

    public void setHidden(boolean hidden) {
        if (this.hiddenCheckBox.isSelected() != hidden) {
            this.hiddenCheckBox.click();
        }
    }

    public void waitToLoad() {
        this.contentEditor.waitToLoad();
        this.summaryEditor.waitToLoad();
    }

    protected BlogPostViewPage createViewPage() {
        return new BlogPostViewPage();
    }
}

