/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.cache.util;

import java.io.File;
import org.xwiki.cache.config.CacheConfiguration;

public abstract class AbstractCacheConfigurationLoader {
    private static final String CONFX_CACHE_PATH = "cache.path";
    private CacheConfiguration configuration;
    private String defaultPropsId;

    public AbstractCacheConfigurationLoader(CacheConfiguration configuration, String defaultPropsId) {
        this.configuration = (CacheConfiguration)configuration.clone();
        this.defaultPropsId = defaultPropsId;
    }

    public CacheConfiguration getCacheConfiguration() {
        return this.configuration;
    }

    protected String createTempDir() {
        String path = (String)this.configuration.get(CONFX_CACHE_PATH);
        if (path == null) {
            File tempDir;
            path = System.getProperty("java.io.tmpdir") + File.separator + "xwiki";
            if (this.configuration.getConfigurationId() == null) {
                path = path + File.separator + this.configuration.getConfigurationId() + File.separator;
            }
            if (!(tempDir = new File(path)).exists()) {
                tempDir.mkdirs();
            }
        }
        return path;
    }

    public String getDefaultPropsId() {
        return this.defaultPropsId;
    }
}

