/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.cache.infinispan.internal;

import org.apache.commons.lang3.StringUtils;
import org.infinispan.config.Configuration;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.file.FileCacheStoreConfig;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.eviction.EntryEvictionConfiguration;
import org.xwiki.cache.util.AbstractCacheConfigurationLoader;

public class InfinispanConfigurationLoader
extends AbstractCacheConfigurationLoader {
    public InfinispanConfigurationLoader(CacheConfiguration configuration) {
        super(configuration, null);
    }

    public boolean customize(Configuration isConfiguration) {
        boolean configChanged = false;
        EntryEvictionConfiguration eec = (EntryEvictionConfiguration)this.getCacheConfiguration().get((Object)"eviction");
        if (eec != null && eec.getAlgorithm() == EntryEvictionConfiguration.Algorithm.LRU) {
            if (eec.containsKey((Object)"maxentries")) {
                isConfiguration.fluent().eviction().strategy(EvictionStrategy.LRU).maxEntries(Integer.valueOf(((Number)eec.get((Object)"maxentries")).intValue()));
                configChanged = true;
            }
            if (eec.getTimeToLive() > 0) {
                isConfiguration.fluent().expiration().maxIdle(Long.valueOf((long)eec.getTimeToLive() * 1000L));
                configChanged = true;
            }
        }
        for (CacheLoaderConfig cacheLoaderConfig : isConfiguration.getCacheLoaders()) {
            FileCacheStoreConfig fileCacheLoaderConfig;
            String location;
            if (!(cacheLoaderConfig instanceof FileCacheStoreConfig) || !StringUtils.isBlank((CharSequence)(location = (fileCacheLoaderConfig = (FileCacheStoreConfig)cacheLoaderConfig).getLocation()))) continue;
            fileCacheLoaderConfig.location(this.createTempDir());
        }
        return configChanged;
    }
}

