/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.cache.infinispan.internal;

import org.apache.commons.lang3.StringUtils;
import org.infinispan.commons.configuration.ConfigurationUtils;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.SingleFileStoreConfiguration;
import org.infinispan.configuration.cache.SingleFileStoreConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.eviction.EvictionStrategy;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.eviction.EntryEvictionConfiguration;
import org.xwiki.cache.util.AbstractCacheConfigurationLoader;

public class InfinispanConfigurationLoader
extends AbstractCacheConfigurationLoader {
    private static final String DEFAULT_SINGLEFILESTORE_LOCATION = "Infinispan-SingleFileStore";

    public InfinispanConfigurationLoader(CacheConfiguration configuration) {
        super(configuration, null);
    }

    private ConfigurationBuilder builder(ConfigurationBuilder builder, Configuration isconfiguration) {
        if (builder != null) {
            return builder;
        }
        ConfigurationBuilder newBuilder = new ConfigurationBuilder();
        if (isconfiguration != null) {
            newBuilder.read(isconfiguration);
        }
        return newBuilder;
    }

    private boolean containsIncompleteFileLoader(Configuration isconfiguration) {
        PersistenceConfiguration persistenceConfiguration = isconfiguration.persistence();
        for (StoreConfiguration storeConfiguration : persistenceConfiguration.stores()) {
            SingleFileStoreConfiguration singleFileStoreConfiguration;
            String location;
            if (!(storeConfiguration instanceof SingleFileStoreConfiguration) || !StringUtils.isBlank((CharSequence)(location = (singleFileStoreConfiguration = (SingleFileStoreConfiguration)storeConfiguration).location())) && !location.equals(DEFAULT_SINGLEFILESTORE_LOCATION)) continue;
            return true;
        }
        return false;
    }

    private ConfigurationBuilder customizeEviction(ConfigurationBuilder currentBuilder, Configuration configuration) {
        ConfigurationBuilder builder = currentBuilder;
        EntryEvictionConfiguration eec = (EntryEvictionConfiguration)this.getCacheConfiguration().get((Object)"eviction");
        if (eec != null && eec.getAlgorithm() == EntryEvictionConfiguration.Algorithm.LRU) {
            if (eec.containsKey((Object)"maxentries")) {
                int maxEntries = ((Number)eec.get((Object)"maxentries")).intValue();
                if (configuration.eviction() == null || configuration.eviction().strategy() != EvictionStrategy.LRU || configuration.eviction().maxEntries() != (long)maxEntries) {
                    builder = this.builder(builder, null);
                    builder.eviction().strategy(EvictionStrategy.LRU);
                    builder.eviction().maxEntries(maxEntries);
                }
            }
            if (eec.getTimeToLive() > 0) {
                long maxIdle = (long)eec.getTimeToLive() * 1000L;
                if (configuration.expiration() == null || configuration.expiration().maxIdle() != maxIdle) {
                    builder = this.builder(builder, null);
                    builder.expiration().maxIdle((long)eec.getTimeToLive() * 1000L);
                }
            }
        }
        return builder;
    }

    private ConfigurationBuilder completeFilesystem(ConfigurationBuilder currentBuilder, Configuration configuration) {
        ConfigurationBuilder builder = currentBuilder;
        if (this.containsIncompleteFileLoader(configuration)) {
            builder = this.builder(builder, configuration);
            PersistenceConfigurationBuilder persistence = builder.persistence();
            persistence.clearStores();
            for (StoreConfiguration storeConfiguration : configuration.persistence().stores()) {
                if (storeConfiguration instanceof SingleFileStoreConfiguration) {
                    SingleFileStoreConfiguration singleFileStoreConfiguration = (SingleFileStoreConfiguration)storeConfiguration;
                    String location = singleFileStoreConfiguration.location();
                    if (!StringUtils.isBlank((CharSequence)location) && !location.equals(DEFAULT_SINGLEFILESTORE_LOCATION)) continue;
                    SingleFileStoreConfigurationBuilder singleFileStoreConfigurationBuilder = persistence.addSingleFileStore();
                    singleFileStoreConfigurationBuilder.read(singleFileStoreConfiguration);
                    singleFileStoreConfigurationBuilder.location(this.createTempDir());
                    continue;
                }
                Class storeBuilderClass = ConfigurationUtils.builderFor((Object)storeConfiguration);
                StoreConfigurationBuilder storeBuilder = persistence.addStore(storeBuilderClass);
                storeBuilder.read((Object)storeConfiguration);
            }
        }
        return builder;
    }

    public Configuration customize(Configuration defaultConfiguration, Configuration namedConfiguration) {
        ConfigurationBuilder builder = null;
        if (namedConfiguration == null) {
            builder = this.customizeEviction(builder, defaultConfiguration);
        }
        if (namedConfiguration != null) {
            builder = this.completeFilesystem(builder, namedConfiguration);
        }
        return builder != null ? builder.build() : null;
    }
}

