/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.cache.infinispan.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.slf4j.Logger;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheException;
import org.xwiki.cache.CacheFactory;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.infinispan.internal.InfinispanCache;
import org.xwiki.cache.infinispan.internal.InfinispanConfigurationLoader;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Disposable;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.environment.Environment;

@Component
@Named(value="infinispan")
@Singleton
public class InfinispanCacheFactory
implements CacheFactory,
Initializable,
Disposable {
    private static final String DEFAULT_CONFIGURATION_FILE = "/WEB-INF/cache/infinispan/config.xml";
    @Inject
    private Logger logger;
    @Inject
    private ComponentManager componentManager;
    private Environment environment;
    private EmbeddedCacheManager cacheManager;

    public void initialize() throws InitializationException {
        try {
            this.environment = (Environment)this.componentManager.getInstance(Environment.class);
        }
        catch (ComponentLookupException e) {
            this.logger.debug("Can't find any Environment", (Throwable)e);
        }
        InputStream configurationStream = this.getConfigurationFileAsStream();
        if (configurationStream != null) {
            configurationStream = this.getConfigurationFileAsStream();
            try {
                this.cacheManager = new DefaultCacheManager(configurationStream);
            }
            catch (IOException e) {
                throw new InitializationException("Failed to create Infinispan cache manager", (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)configurationStream);
            }
        } else {
            this.cacheManager = new DefaultCacheManager();
        }
    }

    public void dispose() throws ComponentLifecycleException {
        this.getCacheManager().stop();
    }

    public EmbeddedCacheManager getCacheManager() {
        return this.cacheManager;
    }

    private InputStream getConfigurationFileAsStream() {
        InputStream is = null;
        if (this.environment != null) {
            is = this.environment.getResourceAsStream(DEFAULT_CONFIGURATION_FILE);
        }
        return is;
    }

    public <T> Cache<T> newCache(CacheConfiguration configuration) throws CacheException {
        InfinispanConfigurationLoader loader = new InfinispanConfigurationLoader(configuration);
        String cacheName = configuration.getConfigurationId();
        Configuration modifiedConfiguration = loader.customize(this.cacheManager.getDefaultCacheConfiguration(), cacheName != null ? this.cacheManager.getCacheConfiguration(cacheName) : null);
        if (cacheName == null) {
            cacheName = UUID.randomUUID().toString();
            loader.getCacheConfiguration().setConfigurationId(cacheName);
        }
        if (modifiedConfiguration != null) {
            this.cacheManager.defineConfiguration(cacheName, modifiedConfiguration);
        }
        return new InfinispanCache(this.cacheManager, loader.getCacheConfiguration());
    }
}

