/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.cache.jbosscache.internal;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.NodeEvicted;
import org.jboss.cache.notifications.annotation.NodeModified;
import org.jboss.cache.notifications.annotation.NodeRemoved;
import org.jboss.cache.notifications.event.NodeEvictedEvent;
import org.jboss.cache.notifications.event.NodeModifiedEvent;
import org.jboss.cache.notifications.event.NodeRemovedEvent;
import org.xwiki.cache.DisposableCacheValue;
import org.xwiki.cache.jbosscache.internal.JBossCacheCacheConfiguration;
import org.xwiki.cache.jbosscache.internal.JBossCacheCacheEntry;
import org.xwiki.cache.jbosscache.internal.event.JBossCacheCacheEntryEvent;
import org.xwiki.cache.util.AbstractCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CacheListener
public class JBossCacheCache<T>
extends AbstractCache<T> {
    public static final Fqn<String> ROOT_FQN = Fqn.fromString((String)"/xwiki");
    private static final Log LOG = LogFactory.getLog(JBossCacheCache.class);
    private static final String DATA_KEY = "data";
    private JBossCacheCacheConfiguration jbosscacheConfiguration;
    private Cache<String, T> cache;
    private Map<String, T> cachedObjects = new HashMap<String, T>();
    private ConcurrentMap<String, Map<String, T>> preEventData = new ConcurrentHashMap<String, Map<String, T>>();

    public void initialize(JBossCacheCacheConfiguration jbosscacheConfiguration) {
        this.jbosscacheConfiguration = jbosscacheConfiguration;
        this.configuration = jbosscacheConfiguration.getCacheConfiguration();
        DefaultCacheFactory factory = new DefaultCacheFactory();
        this.cache = factory.createCache(this.jbosscacheConfiguration.getJBossCacheConfiguration());
        this.cache.addCacheListener((Object)this);
        this.cache.create();
        this.cache.start();
    }

    private void pushDisposableCacheValue(String key, T obj) {
        if (obj instanceof DisposableCacheValue) {
            this.cachedObjects.put(key, obj);
        }
    }

    private T popDisposableCacheValue(String key) {
        return this.cachedObjects.remove(key);
    }

    public void remove(String key) {
        this.cache.removeNode(Fqn.fromRelativeElements(ROOT_FQN, (Object[])new String[]{key}));
    }

    public void set(String key, T obj) {
        this.cache.put(Fqn.fromRelativeElements(ROOT_FQN, (Object[])new String[]{key}), (Object)DATA_KEY, obj);
        this.pushDisposableCacheValue(key, obj);
    }

    public T get(String key) {
        return (T)this.cache.get(Fqn.fromRelativeElements(ROOT_FQN, (Object[])new String[]{key}), (Object)DATA_KEY);
    }

    public void removeAll() {
        this.cache.removeNode(ROOT_FQN);
    }

    public void dispose() {
        super.dispose();
        this.cache.stop();
        this.cache.destroy();
    }

    @NodeEvicted
    public void nodeEvicted(NodeEvictedEvent event) {
        if (!event.getFqn().isChildOf(ROOT_FQN)) {
            if (!event.getFqn().equals(ROOT_FQN)) {
                LOG.warn((Object)MessageFormat.format("The [{0}] node has been evicted but it should not even have been part of the cache", event.getFqn()));
            } else {
                LOG.debug((Object)"The entire cache has been evicted");
            }
            return;
        }
        String key = event.getFqn().getLastElementAsString();
        if (!event.isPre()) {
            this.cacheEntryRemoved(key, null);
        }
    }

    @NodeRemoved
    public void nodeRemoved(NodeRemovedEvent event) {
        if (!event.getFqn().isChildOf(ROOT_FQN)) {
            if (!event.getFqn().equals(ROOT_FQN)) {
                LOG.warn((Object)MessageFormat.format("The [{0}] node has been removed but it should not even have been part of the cache", event.getFqn()));
            } else {
                LOG.debug((Object)"The entire cache has been removed");
            }
            return;
        }
        Map data = event.getData();
        String key = event.getFqn().getLastElementAsString();
        if (event.isPre()) {
            this.preEventData.put(key, data);
        } else {
            this.cacheEntryRemoved(key, ((Map)this.preEventData.get(key)).get(DATA_KEY));
            this.preEventData.remove(key);
        }
    }

    @NodeModified
    public void nodeModified(NodeModifiedEvent event) {
        if (!event.getFqn().isChildOf(ROOT_FQN)) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)MessageFormat.format("The node {0} should not has been modified", event.getFqn()));
            }
            return;
        }
        Map data = event.getData();
        String key = event.getFqn().getLastElementAsString();
        if (event.isPre()) {
            this.preEventData.put(key, data);
        } else {
            if (data.containsKey(DATA_KEY) && event.getModificationType() != NodeModifiedEvent.ModificationType.REMOVE_DATA) {
                this.cacheEntryInserted(key, data.get(DATA_KEY));
            }
            this.preEventData.remove(key);
        }
    }

    private void cacheEntryInserted(String key, T value) {
        JBossCacheCacheEntryEvent<T> event = new JBossCacheCacheEntryEvent<T>(new JBossCacheCacheEntry<T>(this, key, value));
        Map preMap = (Map)this.preEventData.get(key);
        Object previousValue = preMap.get(DATA_KEY);
        if (previousValue != null) {
            if (previousValue != value) {
                this.popDisposableCacheValue(key);
                this.disposeCacheValue(previousValue);
            }
            this.sendEntryModifiedEvent(event);
        } else {
            this.sendEntryAddedEvent(event);
        }
    }

    private void cacheEntryRemoved(String key, T value) {
        T obj = this.popDisposableCacheValue(key);
        if (obj == null) {
            obj = value;
        }
        JBossCacheCacheEntryEvent<T> event = new JBossCacheCacheEntryEvent<T>(new JBossCacheCacheEntry<T>(this, key, obj));
        this.sendEntryRemovedEvent(event);
    }
}

