/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.calendar;

import com.xpn.xwiki.XWikiContext;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class CalendarParams {
    public static final String CONFIG_LOWER_BOUND = "xwiki.calendar.bound.prev";
    public static final int CONFIG_DEFAULT_LOWER_BOUND = 6;
    public static final String CONFIG_UPPER_BOUND = "xwiki.calendar.bound.next";
    public static final int CONFIG_DEFAULT_UPPER_BOUND = 12;
    private Map map = new HashMap();

    public CalendarParams() {
    }

    public CalendarParams(Map map) {
        this.map = map;
    }

    public Object get(Object key) {
        return this.map.get(key);
    }

    public void put(Object key, Object value) {
        this.map.put(key, value);
    }

    public Calendar getCalendar(Locale locale) {
        Calendar cal = Calendar.getInstance(locale);
        cal.setTime(new Date());
        String smonth = (String)this.get("month");
        cal.set(5, 1);
        try {
            String syear;
            if (smonth != null && !smonth.trim().equals("")) {
                if (smonth.indexOf("+") != -1) {
                    cal.add(2, Integer.parseInt(smonth.substring(1)));
                } else if (smonth.indexOf("-") != -1) {
                    cal.add(2, -Integer.parseInt(smonth.substring(1)));
                } else {
                    cal.set(2, Integer.parseInt(smonth));
                }
            }
            if ((syear = (String)this.get("year")) != null && !syear.trim().equals("")) {
                if (syear.indexOf("+") != -1) {
                    cal.add(1, Integer.parseInt(syear));
                } else if (syear.indexOf("-") != -1) {
                    cal.add(1, Integer.parseInt(syear));
                } else {
                    cal.set(1, Integer.parseInt(syear));
                }
            }
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        return cal;
    }

    public String computePrevMonthURL(XWikiContext context) {
        Calendar c = this.getCalendar(Locale.getDefault());
        int prevBound = (int)context.getWiki().ParamAsLong(CONFIG_LOWER_BOUND, 6L);
        if (prevBound <= 0 || Calendar.getInstance().get(2) - c.get(2) + 12 * (Calendar.getInstance().get(1) - c.get(1)) < prevBound) {
            c.add(2, -1);
            return this.getQueryString(c);
        }
        return "";
    }

    public String computeNextMonthURL(XWikiContext context) {
        Calendar c = this.getCalendar(Locale.getDefault());
        int nextBound = (int)context.getWiki().ParamAsLong(CONFIG_UPPER_BOUND, 12L);
        if (nextBound <= 0 || c.get(2) - Calendar.getInstance().get(2) + 12 * (c.get(1) - Calendar.getInstance().get(1)) < nextBound) {
            c.add(2, 1);
            return this.getQueryString(c);
        }
        return "";
    }

    public String computePrevMonthURL() {
        Calendar c = this.getCalendar(Locale.getDefault());
        c.add(2, -1);
        return this.getQueryString(c);
    }

    public String computeNextMonthURL() {
        Calendar c = this.getCalendar(Locale.getDefault());
        c.add(2, 1);
        return this.getQueryString(c);
    }

    protected String getQueryString(Calendar c) {
        if (c.get(1) != Calendar.getInstance().get(1)) {
            return "?year=" + c.get(1) + "&amp;month=" + c.get(2);
        }
        return "?month=" + c.get(2);
    }
}

