/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.calendar;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Api;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.plugin.XWikiDefaultPlugin;
import com.xpn.xwiki.plugin.XWikiPluginInterface;
import com.xpn.xwiki.plugin.calendar.CalendarData;
import com.xpn.xwiki.plugin.calendar.CalendarParams;
import com.xpn.xwiki.plugin.calendar.CalendarPluginApi;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Calendar;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.rendering.syntax.Syntax;

public class CalendarPlugin
extends XWikiDefaultPlugin
implements XWikiPluginInterface {
    public CalendarPlugin(String name, String className, XWikiContext context) {
        super(name, className, context);
    }

    protected BaseClass getCalendarEventClass(XWikiContext context) throws XWikiException {
        XWikiDocument doc;
        XWiki xwiki = context.getWiki();
        boolean needsUpdate = false;
        try {
            doc = xwiki.getDocument(new DocumentReference(context.getDatabase(), "XWiki", "CalendarEvent"), context);
        }
        catch (Exception e) {
            doc = new XWikiDocument(new DocumentReference(context.getDatabase(), "XWiki", "CalendarEvent"));
            needsUpdate = true;
        }
        BaseClass bclass = doc.getXClass();
        needsUpdate |= bclass.addTextField("user", "User", 30);
        needsUpdate |= bclass.addDateField("startDate", "Start Date", "MM/dd/yyyy HH:mm");
        needsUpdate |= bclass.addDateField("endDate", "End Date", "MM/dd/yyyy HH:mm");
        needsUpdate |= bclass.addTextField("title", "Title", 30);
        needsUpdate |= bclass.addTextAreaField("description", "Description", 40, 5);
        needsUpdate |= bclass.addTextField("url", "URL (optional)", 30);
        needsUpdate |= bclass.addTextField("location", "Location", 30);
        needsUpdate |= bclass.addStaticListField("category", "Category", 3, false, "");
        String content = doc.getContent();
        if (content == null || content.equals("")) {
            needsUpdate = true;
            doc.setContent("1 CalendarEvent");
            doc.setSyntax(Syntax.XWIKI_1_0);
        }
        if (needsUpdate) {
            xwiki.saveDocument(doc, context);
        }
        return bclass;
    }

    public CalendarParams getCalendarParams(String month, String year, XWikiContext context) {
        CalendarParams cparams = new CalendarParams();
        cparams.put("month", month);
        cparams.put("year", year);
        return cparams;
    }

    public String getHTMLCalendar(CalendarParams calendarParams, String user, XWikiContext context) throws XWikiException {
        CalendarData cData = new CalendarData(user, context);
        return this.getHTMLCalendar(calendarParams, cData, context);
    }

    public String getHTMLCalendar(CalendarParams calendarParams, XWikiDocument doc, String user, XWikiContext context) throws XWikiException {
        CalendarData cData = new CalendarData(doc, user, context);
        return this.getHTMLCalendar(calendarParams, cData, context);
    }

    public String getHTMLCalendar(CalendarParams calendarParams, String hql, String user, XWikiContext context) throws XWikiException {
        CalendarData cData = new CalendarData(hql, user, context);
        return this.getHTMLCalendar(calendarParams, cData, context);
    }

    public String getHTMLCalendar(CalendarParams calendarParams, String hql, int nb, XWikiContext context) throws XWikiException {
        CalendarData cData = new CalendarData(hql, nb, context);
        return this.getHTMLCalendar(calendarParams, cData, context);
    }

    public String getHTMLCalendar(CalendarParams calendarParams, CalendarData calendarData, XWikiContext context) throws XWikiException {
        String dateFormat;
        StringBuffer output = new StringBuffer();
        Locale locale = context.getResponse().getLocale();
        if (locale == null) {
            locale = new Locale("en");
        }
        java.util.Calendar todayCal = java.util.Calendar.getInstance(locale);
        this.fixJDKLocaleBugs(todayCal, locale);
        todayCal.setTime(new Date());
        String id = (String)calendarParams.get("id");
        if (id == null) {
            id = (String)context.get((Object)"calendarId");
            id = id == null ? "1" : "" + (Integer.parseInt(id.trim()) + 1);
            context.put((Object)"calendarId", (Object)id);
        }
        if ((dateFormat = (String)calendarParams.get("dateformat")) == null) {
            dateFormat = "MMMM yyyy";
        }
        SimpleDateFormat formatTitle = new SimpleDateFormat(dateFormat, locale);
        String[] mDayNames = this.buildDayNames(locale);
        java.util.Calendar dayCal = calendarParams.getCalendar(locale);
        this.fixJDKLocaleBugs(dayCal, locale);
        java.util.Calendar cal = (java.util.Calendar)dayCal.clone();
        cal.set(5, cal.getMinimum(5));
        this.fixJDKLocaleBugs(cal, locale);
        while (cal.get(7) != dayCal.getFirstDayOfWeek()) {
            cal.add(5, -1);
        }
        String msgPreviousMonth = context.getMessageTool().get("web.paging.previousPage");
        String msgNextMonth = context.getMessageTool().get("web.paging.nextPage");
        output.append("<table summary=\"Event calendar\"");
        output.append(" id=\"wiki-calendar-table-" + id + "\"");
        output.append(" class=\"wiki-calendar-table\">");
        output.append("<tr class=\"wiki-calendar-month\">");
        String tempMonthUrl = calendarParams.computePrevMonthURL(context);
        tempMonthUrl = tempMonthUrl != "" ? "<a href=\"" + tempMonthUrl + "\">" + msgPreviousMonth + "</a>" : "<span class=\"disabled\">" + msgPreviousMonth + "</span>";
        output.append("<th class=\"wiki-calendar-month-nav prev-month\">" + tempMonthUrl + "</th>");
        output.append("<th colspan=\"5\" class=\"wiki-calendar-monthyearrow\">");
        output.append(formatTitle.format(dayCal.getTime()));
        output.append("</th>");
        tempMonthUrl = calendarParams.computeNextMonthURL(context);
        tempMonthUrl = tempMonthUrl != "" ? "<a href=\"" + tempMonthUrl + "\">" + msgNextMonth + "</a>" : "<span class=\"disabled\">" + msgNextMonth + "</span>";
        output.append("<th class=\"wiki-calendar-month-nav next-month\">" + tempMonthUrl + "</th>");
        output.append("</tr>");
        output.append("<tr class=\"wiki-calendar-daynamerow\">");
        for (int d = 0; d < 7; ++d) {
            output.append("<th scope=\"col\">");
            output.append(mDayNames[d]);
            output.append("</th>");
        }
        output.append("</tr>");
        int weeks = (int)Math.ceil((double)(dayCal.getActualMaximum(5) + (dayCal.get(7) - dayCal.getFirstDayOfWeek() + 7) % 7) / 7.0);
        for (int w = 0; w < weeks; ++w) {
            output.append("<tr>");
            for (int d = 0; d < 7; ++d) {
                String script = (String)calendarParams.get("script");
                String content = script == null ? calendarData.getContent(cal, (String)calendarParams.get("user"), (String)calendarParams.get("location"), (List)calendarParams.get("categories"), context) : calendarData.getContent(cal, script, context);
                if (cal.get(5) == todayCal.get(5) && cal.get(2) == todayCal.get(2) && cal.get(1) == todayCal.get(1)) {
                    this.printDay(output, cal, content, true, cal.get(2) == dayCal.get(2));
                } else if (cal.get(2) == dayCal.get(2) && cal.get(1) == dayCal.get(1)) {
                    this.printDay(output, cal, content, false, true);
                } else {
                    this.printDay(output, cal, content, false, false);
                }
                cal.add(5, 1);
            }
            output.append("</tr>");
        }
        output.append("</table>");
        return output.toString();
    }

    private void printDay(StringBuffer output, java.util.Calendar cal, String content, boolean today, boolean inThisMonth) {
        if (inThisMonth) {
            if (today) {
                output.append("<td class=\"wiki-calendar-today\">");
            } else {
                output.append("<td class=\"wiki-calendar-dayinmonth\">");
            }
        } else if (today) {
            output.append("<td class=\"wiki-calendar-today-notinmonth\">");
        } else {
            output.append("<td class=\"wiki-calendar-daynotinmonth\">");
        }
        String classname = "wiki-calendar-daytitle";
        if (content != null && content.length() > 0) {
            classname = classname + " wiki-calendar-daytitle-hasevent";
        }
        output.append("<div class=\"" + classname + "\">");
        output.append(cal.get(5));
        if (content != null && content.length() > 0) {
            output.append(content);
        }
        output.append("</div>");
        output.append("</td>");
    }

    private String[] buildDayNames(Locale locale) {
        String[] mDayNames = new String[7];
        java.util.Calendar dayNameCal = java.util.Calendar.getInstance(locale);
        this.fixJDKLocaleBugs(dayNameCal, locale);
        SimpleDateFormat dayFormatter = new SimpleDateFormat("EEE", locale);
        dayNameCal.set(7, dayNameCal.getFirstDayOfWeek());
        for (int dnum = 0; dnum < 7; ++dnum) {
            mDayNames[dnum] = dayFormatter.format(dayNameCal.getTime());
            dayNameCal.add(5, 1);
        }
        return mDayNames;
    }

    public String getName() {
        return "calendar";
    }

    public void init(XWikiContext context) {
        try {
            this.getCalendarEventClass(context);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void virtualInit(XWikiContext context) {
        try {
            this.getCalendarEventClass(context);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Api getPluginApi(XWikiPluginInterface plugin, XWikiContext context) {
        return new CalendarPluginApi((CalendarPlugin)plugin, context);
    }

    public Calendar getCalendar(String surl, XWikiContext context) throws ParserException, IOException {
        CalendarBuilder builder = new CalendarBuilder();
        String sical = context.getWiki().getURLContent(surl, context);
        StringReader reader = new StringReader(sical);
        Calendar calendar = builder.build((Reader)reader);
        return calendar;
    }

    public Calendar getCalendar(String surl, String username, String password, XWikiContext context) throws ParserException, IOException {
        CalendarBuilder builder = new CalendarBuilder();
        String sical = context.getWiki().getURLContent(surl, username, password, context);
        StringReader reader = new StringReader(sical);
        Calendar calendar = builder.build((Reader)reader);
        return calendar;
    }

    private void fixJDKLocaleBugs(java.util.Calendar c, Locale l) {
        if ("ro".equals(l.getLanguage())) {
            c.setFirstDayOfWeek(2);
        }
    }
}

