/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.captcha;

import org.xwiki.stability.Unstable;

/**
 * Exception in the CAPTCHA module's operations.
 *
 * @version $Id: 1f39ef0f0da37c16c78b671b18435445f2ba9969 $
 * @since 10.8RC1
 */
@Unstable
public class CaptchaException extends Exception
{
    private static final long serialVersionUID = -3676401099689936641L;

    /**
     * Constructor.
     *
     * @param message the detail message
     * @param cause the cause of this exception
     */
    public CaptchaException(String message, Throwable cause)
    {
        super(message, cause);
    }
}
