/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.chart.internal.source;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.chart.internal.source.AbstractTableBlockDataSource;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.TableBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.ClassBlockMatcher;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.parser.Parser;

@Component
@Named(value="inline")
@Singleton
public class MacroContentTableBlockDataSource
extends AbstractTableBlockDataSource {
    @Inject
    private ComponentManager componentManager;
    @Inject
    private DocumentAccessBridge docBridge;

    @Override
    protected TableBlock getTableBlock(String macroContent, Map<String, String> macroParameters) throws MacroExecutionException {
        XDOM xdom;
        if (StringUtils.isEmpty((CharSequence)macroContent)) {
            throw new MacroExecutionException("A Chart Macro using an inline source must have a data table defined in its content.");
        }
        try {
            Parser parser = (Parser)this.componentManager.lookup(Parser.class, this.docBridge.getDocument(this.docBridge.getCurrentDocumentReference()).getSyntax().toIdString());
            xdom = parser.parse((Reader)new StringReader(macroContent));
        }
        catch (Exception ex) {
            throw new MacroExecutionException("Error while parsing macro content.", (Throwable)ex);
        }
        List tableBlocks = xdom.getBlocks((BlockMatcher)new ClassBlockMatcher(TableBlock.class), Block.Axes.DESCENDANT);
        if (tableBlocks.size() == 0) {
            throw new MacroExecutionException("Unable to locate a suitable data table.");
        }
        return (TableBlock)tableBlocks.get(0);
    }
}

