/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.chart;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.chart.ChartGenerator;
import org.xwiki.chart.ChartGeneratorException;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.container.Container;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.ImageBlock;
import org.xwiki.rendering.block.LinkBlock;
import org.xwiki.rendering.block.ParagraphBlock;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.chart.ChartDataSource;
import org.xwiki.rendering.macro.chart.ChartMacroParameters;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component
@Named(value="chart")
@Singleton
public class ChartMacro
extends AbstractMacro<ChartMacroParameters> {
    private static final String DESCRIPTION = "Displays a graphical chart generated from miscellaneous data sources";
    private static final String CONTENT_DESCRIPTION = "Input data for the chart macro (Ex. for 'inline' source mode)";
    @Inject
    private ChartGenerator chartGenerator;
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Container container;

    public ChartMacro() {
        super("Chart", DESCRIPTION, (ContentDescriptor)new DefaultContentDescriptor(CONTENT_DESCRIPTION), ChartMacroParameters.class);
        this.setDefaultCategory("Content");
    }

    public boolean supportsInlineMode() {
        return true;
    }

    public List<Block> execute(ChartMacroParameters macroParams, String content, MacroTransformationContext context) throws MacroExecutionException {
        String imageLocation = this.documentAccessBridge.getURL(null, "charting", null, null) + "/" + this.generateChart(macroParams, content);
        String title = macroParams.getTitle();
        ResourceReference reference = new ResourceReference(imageLocation, ResourceType.URL);
        ImageBlock imageBlock = new ImageBlock(new ResourceReference(imageLocation, ResourceType.URL), true);
        imageBlock.setParameter("alt", title);
        LinkBlock linkBlock = new LinkBlock(Collections.singletonList(imageBlock), reference, true);
        linkBlock.setParameter("title", title);
        Object resultBlock = context.isInline() ? linkBlock : new ParagraphBlock(Collections.singletonList(linkBlock));
        return Collections.singletonList(resultBlock);
    }

    private String generateChart(ChartMacroParameters parameters, String content) throws MacroExecutionException {
        File chartFile;
        Map<String, String> paramsMap = parameters.getParametersMap();
        String source = paramsMap.get("source");
        try {
            ChartDataSource dataSource = (ChartDataSource)this.componentManager.lookup(ChartDataSource.class, source);
            byte[] chart = this.chartGenerator.generate(dataSource.buildModel(content, paramsMap), paramsMap);
            chartFile = this.getChartImageFile(parameters);
            FileOutputStream fos = new FileOutputStream(chartFile);
            fos.write(chart);
            fos.close();
        }
        catch (ComponentLookupException ex) {
            throw new MacroExecutionException("Invalid source parameter.", (Throwable)ex);
        }
        catch (ChartGeneratorException ex) {
            throw new MacroExecutionException("Error while rendering chart.", (Throwable)ex);
        }
        catch (Exception ex) {
            throw new MacroExecutionException("Error while saving chart image.", (Throwable)ex);
        }
        return chartFile.getName();
    }

    protected File getChartImageFile(ChartMacroParameters parameters) {
        File chartsDir = new File(this.container.getApplicationContext().getTemporaryDirectory(), "charts");
        return new File(chartsDir, Math.abs(parameters.hashCode()) + ".png");
    }
}

