/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.charts.plots;

import com.xpn.xwiki.plugin.charts.ChartCustomizer;
import com.xpn.xwiki.plugin.charts.exceptions.DataSourceException;
import com.xpn.xwiki.plugin.charts.exceptions.GenerateException;
import com.xpn.xwiki.plugin.charts.params.ChartParams;
import com.xpn.xwiki.plugin.charts.plots.PlotFactory;
import com.xpn.xwiki.plugin.charts.source.DataSource;
import java.lang.reflect.Constructor;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

public class PiePlotFactory
implements PlotFactory {
    private static PiePlotFactory uniqueInstance = new PiePlotFactory();

    private PiePlotFactory() {
    }

    public static PiePlotFactory getInstance() {
        return uniqueInstance;
    }

    @Override
    public Plot create(DataSource dataSource, ChartParams params) throws GenerateException, DataSourceException {
        PiePlot plot;
        Class plotClass;
        String category;
        DefaultPieDataset dataset = new DefaultPieDataset();
        String dataSeries = params.getString("series");
        if (dataSeries.equals("columns")) {
            for (int row = 0; row < dataSource.getRowCount(); ++row) {
                if (dataSource.hasHeaderColumn()) {
                    category = dataSource.getHeaderColumnValue(row);
                    dataset.setValue((Comparable)((Object)category), dataSource.getCell(row, 0));
                    continue;
                }
                dataset.setValue((Comparable)((Object)("Category " + (row + 1))), dataSource.getCell(row, 0));
            }
        } else if (dataSeries.equals("rows")) {
            for (int column = 0; column < dataSource.getColumnCount(); ++column) {
                if (dataSource.hasHeaderRow()) {
                    category = dataSource.getHeaderRowValue(column);
                    dataset.setValue((Comparable)((Object)category), dataSource.getCell(0, column));
                    continue;
                }
                dataset.setValue((Comparable)((Object)("Category " + (column + 1))), dataSource.getCell(0, column));
            }
        } else {
            throw new GenerateException("Invalid series parameter:" + dataSeries);
        }
        if ((plotClass = params.getClass("renderer")) != null) {
            try {
                Constructor ctor = plotClass.getConstructor(PieDataset.class);
                plot = (PiePlot)ctor.newInstance(dataset);
            }
            catch (Throwable e) {
                throw new GenerateException(e);
            }
        } else {
            plot = new PiePlot((PieDataset)dataset);
        }
        ChartCustomizer.customizePiePlot(plot, params);
        return plot;
    }
}

