/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.charts.plots;

import com.xpn.xwiki.plugin.charts.exceptions.DataSourceException;
import com.xpn.xwiki.plugin.charts.exceptions.GenerateException;
import com.xpn.xwiki.plugin.charts.params.ChartParams;
import com.xpn.xwiki.plugin.charts.source.DataSource;
import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class TimeSeriesCollectionFactory {
    private static TimeSeriesCollectionFactory uniqueInstance = new TimeSeriesCollectionFactory();

    private TimeSeriesCollectionFactory() {
    }

    public static TimeSeriesCollectionFactory getInstance() {
        return uniqueInstance;
    }

    public XYDataset create(DataSource dataSource, ChartParams params) throws GenerateException, DataSourceException {
        DateFormat format;
        String dataSeries = params.getString("series");
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        Class<Day> timePeriodClass = params.getClass("time_period");
        if (timePeriodClass == null) {
            timePeriodClass = Day.class;
        }
        if ((format = params.getDateFormat("date_format")) == null) {
            format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        }
        if (dataSeries.equals("columns")) {
            if (!dataSource.hasHeaderColumn()) {
                throw new GenerateException("Header column required");
            }
            for (int column = 0; column < dataSource.getColumnCount(); ++column) {
                String seriesName = dataSource.hasHeaderRow() ? dataSource.getHeaderRowValue(column) : "Series " + (column + 1);
                TimeSeries series = new TimeSeries((Comparable)((Object)seriesName), timePeriodClass);
                for (int row = 0; row < dataSource.getRowCount(); ++row) {
                    RegularTimePeriod period;
                    try {
                        Date date = format.parse(dataSource.getHeaderColumnValue(row));
                        Constructor ctor = timePeriodClass.getConstructor(Date.class);
                        period = (RegularTimePeriod)ctor.newInstance(date);
                    }
                    catch (Exception e) {
                        throw new GenerateException(e);
                    }
                    series.add(period, dataSource.getCell(row, column));
                }
                dataset.addSeries(series);
            }
        } else if (dataSeries.equals("rows")) {
            if (!dataSource.hasHeaderRow()) {
                throw new GenerateException("Header row required");
            }
            for (int row = 0; row < dataSource.getRowCount(); ++row) {
                String seriesName = dataSource.hasHeaderColumn() ? dataSource.getHeaderColumnValue(row) : "Series " + (row + 1);
                TimeSeries series = new TimeSeries((Comparable)((Object)seriesName), timePeriodClass);
                for (int column = 0; column < dataSource.getColumnCount(); ++column) {
                    RegularTimePeriod period;
                    try {
                        Date date = format.parse(dataSource.getHeaderRowValue(column));
                        Constructor ctor = timePeriodClass.getConstructor(Date.class);
                        period = (RegularTimePeriod)ctor.newInstance(date);
                    }
                    catch (Exception e) {
                        throw new GenerateException(e);
                    }
                    series.add(period, dataSource.getCell(row, column));
                }
                dataset.addSeries(series);
            }
        } else {
            throw new GenerateException("Invalid series parameter:" + dataSeries);
        }
        return dataset;
    }
}

