/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.chart.internal;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Plot;
import org.xwiki.chart.ChartGenerator;
import org.xwiki.chart.ChartGeneratorException;
import org.xwiki.chart.internal.DrawingSupplierFactory;
import org.xwiki.chart.internal.plot.AreaPlotGenerator;
import org.xwiki.chart.internal.plot.Bar3DPlotGenerator;
import org.xwiki.chart.internal.plot.BarPlotGenerator;
import org.xwiki.chart.internal.plot.Line3DPlotGenerator;
import org.xwiki.chart.internal.plot.LinePlotGenerator;
import org.xwiki.chart.internal.plot.PiePlotGenerator;
import org.xwiki.chart.internal.plot.PlotGenerator;
import org.xwiki.chart.model.ChartModel;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;

@Component
public class DefaultChartGenerator
implements ChartGenerator,
Initializable {
    private Map<String, PlotGenerator> plotGenerators;
    private DrawingSupplierFactory drawingSupplierFactory = new DrawingSupplierFactory();

    public void initialize() throws InitializationException {
        this.plotGenerators = new HashMap<String, PlotGenerator>();
        this.plotGenerators.put("line", new LinePlotGenerator());
        this.plotGenerators.put("bar", new BarPlotGenerator());
        this.plotGenerators.put("area", new AreaPlotGenerator());
        this.plotGenerators.put("pie", new PiePlotGenerator());
        this.plotGenerators.put("line3D", new Line3DPlotGenerator());
        this.plotGenerators.put("bar3D", new Bar3DPlotGenerator());
    }

    @Override
    public byte[] generate(ChartModel model, Map<String, String> parameters) throws ChartGeneratorException {
        this.setDefaultParams(parameters);
        String type = parameters.get("type");
        String title = parameters.get("title");
        PlotGenerator generator = this.plotGenerators.get(type);
        if (null == generator) {
            throw new ChartGeneratorException(String.format("No such chart type : [%s].", type));
        }
        Plot plot = generator.generate(model, parameters);
        plot.setDrawingSupplier(this.drawingSupplierFactory.createDrawingSupplier(parameters));
        JFreeChart jfchart = new JFreeChart(title, plot);
        int width = Integer.parseInt(parameters.get("width"));
        int height = Integer.parseInt(parameters.get("height"));
        try {
            return ChartUtilities.encodeAsPNG((BufferedImage)jfchart.createBufferedImage(width, height));
        }
        catch (IOException ex) {
            throw new ChartGeneratorException("Error while png encoding the chart image.");
        }
    }

    public void setDefaultParams(Map<String, String> parameters) {
        DefaultChartGenerator.setParam("series", "rows", parameters);
        DefaultChartGenerator.setParam("width", "400", parameters);
        DefaultChartGenerator.setParam("height", "300", parameters);
    }

    private static void setParam(String key, String value, Map<String, String> map) {
        if (!map.containsKey(key)) {
            map.put(key, value);
        }
    }
}

