/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.chart.internal.plot;

import java.util.Map;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.xwiki.chart.internal.plot.PlotGenerator;
import org.xwiki.chart.model.ChartModel;

public abstract class AbstractCategoryPlotGenerator
implements PlotGenerator {
    @Override
    public Plot generate(ChartModel model, Map<String, String> parameters) {
        CategoryAxis domainAxis = new CategoryAxis();
        NumberAxis rangeAxis = new NumberAxis();
        return new CategoryPlot((CategoryDataset)this.buildCategoryDataset(model, parameters), domainAxis, (ValueAxis)rangeAxis, this.getRenderer());
    }

    protected abstract CategoryItemRenderer getRenderer();

    public DefaultCategoryDataset buildCategoryDataset(ChartModel model, Map<String, String> parameters) {
        String dataSeries = parameters.get("series");
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        if ("rows".equals(dataSeries)) {
            this.extractRows(model, dataset);
        } else {
            this.extractColumns(model, dataset);
        }
        return dataset;
    }

    private void extractRows(ChartModel model, DefaultCategoryDataset dataset) {
        for (int row = 0; row < model.getRowCount(); ++row) {
            for (int column = 0; column < model.getColumnCount(); ++column) {
                dataset.addValue(model.getCellValue(row, column), (Comparable)((Object)model.getRowHeader(row)), (Comparable)((Object)model.getColumnHeader(column)));
            }
        }
    }

    private void extractColumns(ChartModel model, DefaultCategoryDataset dataset) {
        for (int row = 0; row < model.getRowCount(); ++row) {
            for (int column = 0; column < model.getColumnCount(); ++column) {
                dataset.addValue(model.getCellValue(row, column), (Comparable)((Object)model.getColumnHeader(column)), (Comparable)((Object)model.getRowHeader(row)));
            }
        }
    }
}

