/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.chart.internal.plot;

import java.util.Map;

import javax.inject.Named;
import javax.inject.Singleton;

import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.xwiki.component.annotation.Component;

/**
 * Generate Plots for XY data sets using an area renderer.
 * 
 * @version $Id: ac7633799ef841cd79ca1122961c59618b1e184a $
 * @since 4.2M1
 */
@Component
@Named("xy_area")
@Singleton
public class XYAreaPlotGenerator extends AbstractXYPlotGenerator
{
    @Override
    public XYItemRenderer getRenderer(Map<String, String> parameters)
    {
        return new XYAreaRenderer();
    }
}
