/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.chart.internal.plot;

import java.text.NumberFormat;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.data.general.PieDataset;
import org.xwiki.chart.PlotGeneratorException;
import org.xwiki.chart.internal.plot.PlotGenerator;
import org.xwiki.chart.model.ChartModel;
import org.xwiki.component.annotation.Component;

@Component
@Named(value="pie")
@Singleton
public class PiePlotGenerator
implements PlotGenerator {
    private static final String PIE_LABEL_FORMAT_KEY = "pie_label_format";

    @Override
    public Plot generate(ChartModel model, Map<String, String> parameters) throws PlotGeneratorException {
        PieDataset dataset;
        try {
            dataset = (PieDataset)model.getDataset();
        }
        catch (ClassCastException e) {
            throw new PlotGeneratorException("Incompatible dataset for the pie plot.");
        }
        PiePlot piePlot = new PiePlot(dataset);
        String pieLabelFormat = parameters.get(PIE_LABEL_FORMAT_KEY);
        if (pieLabelFormat != null) {
            piePlot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator(pieLabelFormat, NumberFormat.getNumberInstance(), NumberFormat.getPercentInstance()));
        }
        return piePlot;
    }
}

