/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.chart.plot;

import org.xwiki.chart.axis.AxisType;
import org.xwiki.chart.dataset.DatasetType;

public enum PlotType {
    LINE("line", DatasetType.CATEGORY, AxisType.CATEGORY, AxisType.NUMBER),
    AREA("area", DatasetType.CATEGORY, AxisType.CATEGORY, AxisType.NUMBER),
    BAR("bar", DatasetType.CATEGORY, AxisType.CATEGORY, AxisType.NUMBER),
    STACKEDBAR("stackedbar", DatasetType.CATEGORY, AxisType.CATEGORY, AxisType.NUMBER),
    PIE("pie", DatasetType.PIE, new AxisType[0]),
    BAR3D("bar3D", DatasetType.CATEGORY, AxisType.CATEGORY, AxisType.NUMBER),
    STACKEDBAR3D("stackedbar3D", DatasetType.CATEGORY, AxisType.CATEGORY, AxisType.NUMBER),
    LINE3D("line3D", DatasetType.CATEGORY, AxisType.CATEGORY, AxisType.NUMBER),
    XYAREA("xy_area", DatasetType.XY, AxisType.NUMBER, AxisType.NUMBER),
    XYLINEANDSHAPE("xy_line_and_shape", DatasetType.XY, AxisType.NUMBER, AxisType.NUMBER),
    XYLINE3D("xy_line3D", DatasetType.XY, AxisType.NUMBER, AxisType.NUMBER),
    XYSTEP("xy_step", DatasetType.XY, AxisType.NUMBER, AxisType.NUMBER);

    private final String name;
    private final DatasetType defaultDatasetType;
    private final AxisType[] defaultAxisTypes;

    private PlotType(String name, DatasetType defaultDatasetType, AxisType ... defaultAxisTypes) {
        this.name = name;
        this.defaultDatasetType = defaultDatasetType;
        this.defaultAxisTypes = defaultAxisTypes;
    }

    public String getName() {
        return this.name;
    }

    public DatasetType getDefaultDatasetType() {
        return this.defaultDatasetType;
    }

    public static PlotType forName(String name) {
        for (PlotType plotType : PlotType.values()) {
            if (!name.equals(plotType.getName())) continue;
            return plotType;
        }
        return null;
    }

    public AxisType[] getDefaultAxisTypes() {
        return this.defaultAxisTypes;
    }
}

