/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.chart.internal.plot;

import java.util.Map;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.xwiki.chart.PlotGeneratorException;
import org.xwiki.chart.internal.plot.PlotGenerator;
import org.xwiki.chart.model.ChartModel;

public abstract class AbstractCategoryPlotGenerator
implements PlotGenerator {
    @Override
    public Plot generate(ChartModel model, Map<String, String> parameters) throws PlotGeneratorException {
        if (!(model.getDataset() instanceof CategoryDataset)) {
            throw new PlotGeneratorException("Incompatible dataset for category plot.");
        }
        CategoryDataset dataset = (CategoryDataset)model.getDataset();
        if (!(model.getAxis(0) instanceof CategoryAxis)) {
            throw new PlotGeneratorException("Incompatible axis 0 for category plot.");
        }
        CategoryAxis domainAxis = (CategoryAxis)model.getAxis(0);
        if (!(model.getAxis(1) instanceof ValueAxis)) {
            throw new PlotGeneratorException("Incompatible axis 1 for category plot.");
        }
        ValueAxis rangeAxis = (ValueAxis)model.getAxis(1);
        return new CategoryPlot(dataset, domainAxis, rangeAxis, this.getRenderer(parameters));
    }

    protected abstract CategoryItemRenderer getRenderer(Map<String, String> var1);
}

