/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.internal.AbstractEntityComponentManager;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceValueProvider;
import org.xwiki.model.reference.WikiReference;

@Component
@Named(value="wiki")
@Singleton
public class WikiComponentManager
extends AbstractEntityComponentManager
implements Initializable {
    public static final String ID = "wiki";
    private static final String KEY_PREFIX = "wiki:";
    @Inject
    @Named(value="current")
    private EntityReferenceValueProvider currentProvider;
    @Inject
    private ComponentManager rootComponentManager;

    private String getCurrentWiki() {
        return this.currentProvider.getDefaultValue(EntityType.WIKI);
    }

    @Override
    protected EntityReference getCurrentReference() {
        return new WikiReference(this.getCurrentWiki());
    }

    @Override
    protected String getKey() {
        String wiki = this.getCurrentWiki();
        return wiki != null ? KEY_PREFIX + wiki : null;
    }

    public void initialize() throws InitializationException {
        this.setInternalParent(this.rootComponentManager);
    }
}

