/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.wiki.internal.bridge;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.wiki.WikiComponentException;
import org.xwiki.component.wiki.internal.bridge.ContentParser;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.parser.MissingParserException;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.syntax.Syntax;

@Component
@Singleton
public class DefaultContentParser
implements ContentParser {
    @Inject
    private org.xwiki.rendering.parser.ContentParser contentParser;

    @Override
    public XDOM parse(String content, Syntax syntax) throws WikiComponentException {
        return this.parse(content, syntax, null);
    }

    @Override
    public XDOM parse(String content, Syntax syntax, EntityReference source) throws WikiComponentException {
        try {
            return this.contentParser.parse(content, syntax, source);
        }
        catch (ParseException e) {
            throw new WikiComponentException(String.format("Failed to parse content [%s]", content), e);
        }
        catch (MissingParserException e) {
            throw new WikiComponentException(String.format("Failed to find a parser to parse syntax [%s]", syntax), e);
        }
    }
}

