/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.wiki.internal;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.wiki.WikiComponent;
import org.xwiki.component.wiki.WikiComponentException;
import org.xwiki.component.wiki.WikiComponentManager;
import org.xwiki.model.reference.EntityReference;

@Component(roles={WikiComponentManagerEventListenerHelper.class})
@Singleton
public class WikiComponentManagerEventListenerHelper {
    @Inject
    private WikiComponentManager wikiComponentManager;
    @Inject
    private Logger logger;

    public void registerComponentList(List<WikiComponent> components) {
        for (WikiComponent component : components) {
            try {
                this.wikiComponentManager.registerWikiComponent(component);
            }
            catch (WikiComponentException e) {
                this.logger.warn("Unable to register component(s) from document [{}]: {}", (Object)component.getDocumentReference(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
    }

    public void unregisterComponents(EntityReference entityReference) {
        try {
            this.wikiComponentManager.unregisterWikiComponents(entityReference);
        }
        catch (WikiComponentException e) {
            this.logger.warn("Unable to unregister component(s) from the entity [{}]: {}", (Object)entityReference, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }
}

