/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.wiki.internal;

import java.lang.reflect.Method;

public final class ObjectMethodsProxy {
    private ObjectMethodsProxy() {
    }

    public static Object invoke(Object proxy, Method method, Object[] args) {
        try {
            if (method.equals(Object.class.getMethod("hashCode", null))) {
                return ObjectMethodsProxy.proxyHashCode(proxy);
            }
            if (method.equals(Object.class.getMethod("equals", Object.class))) {
                return ObjectMethodsProxy.proxyEquals(proxy, args[0]);
            }
            if (method.equals(Object.class.getMethod("toString", null))) {
                return ObjectMethodsProxy.proxyToString(proxy);
            }
            throw new InternalError("unexpected Object method dispatched: " + method);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
    }

    private static Integer proxyHashCode(Object proxy) {
        return new Integer(System.identityHashCode(proxy));
    }

    private static Boolean proxyEquals(Object proxy, Object other) {
        return proxy == other ? Boolean.TRUE : Boolean.FALSE;
    }

    private static String proxyToString(Object proxy) {
        return proxy.getClass().getName() + '@' + Integer.toHexString(proxy.hashCode());
    }
}

