/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.wiki.internal;

import com.xpn.xwiki.XWikiContext;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.bridge.event.ApplicationReadyEvent;
import org.xwiki.bridge.event.DocumentCreatedEvent;
import org.xwiki.bridge.event.DocumentDeletedEvent;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.bridge.event.WikiReadyEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.wiki.WikiComponent;
import org.xwiki.component.wiki.WikiComponentBuilder;
import org.xwiki.component.wiki.WikiComponentException;
import org.xwiki.component.wiki.WikiComponentManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.ObservationContext;
import org.xwiki.observation.event.Event;

@Component
@Named(value="defaultWikiComponentManagerEventListener")
@Singleton
public class DefaultWikiComponentManagerEventListener
implements EventListener {
    @Inject
    private Logger logger;
    @Inject
    private WikiComponentManager wikiComponentManager;
    @Inject
    private List<WikiComponentBuilder> wikiComponentProviders;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private ObservationContext observationContext;

    public List<Event> getEvents() {
        return Arrays.asList(new DocumentCreatedEvent(), new DocumentUpdatedEvent(), new DocumentDeletedEvent(), new ApplicationReadyEvent(), new WikiReadyEvent());
    }

    public String getName() {
        return "defaultWikiComponentManagerEventListener";
    }

    public void onEvent(Event event, Object source, Object data) {
        if (source instanceof DocumentModelBridge) {
            DocumentModelBridge document = (DocumentModelBridge)source;
            DocumentReference documentReference = document.getDocumentReference();
            if (event instanceof DocumentCreatedEvent || event instanceof DocumentUpdatedEvent) {
                this.registerComponents(document);
            } else if (event instanceof DocumentDeletedEvent) {
                this.unregisterComponents(documentReference);
            }
        } else if (event instanceof ApplicationReadyEvent || event instanceof WikiReadyEvent) {
            this.registerAllComponents();
        }
    }

    private void registerAllComponents() {
        for (WikiComponentBuilder provider : this.wikiComponentProviders) {
            for (DocumentReference reference : provider.getDocumentReferences()) {
                try {
                    List<WikiComponent> components = provider.buildComponents(reference);
                    for (WikiComponent component : components) {
                        this.wikiComponentManager.registerWikiComponent(component);
                    }
                }
                catch (Exception e) {
                    this.logger.warn("Failed to register the wiki component located in the document [{}]: {}", (Object)reference, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                }
            }
        }
    }

    private void registerComponents(DocumentModelBridge document) {
        DocumentReference documentReference = document.getDocumentReference();
        this.unregisterComponents(documentReference);
        for (WikiComponentBuilder provider : this.wikiComponentProviders) {
            if (!provider.getDocumentReferences().contains(documentReference)) continue;
            try {
                List<WikiComponent> components = provider.buildComponents(documentReference);
                for (WikiComponent component : components) {
                    try {
                        this.wikiComponentManager.registerWikiComponent(component);
                    }
                    catch (WikiComponentException e) {
                        this.logger.warn("Unable to register component(s) from document [{}]: {}", (Object)component.getDocumentReference(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                    }
                }
                break;
            }
            catch (WikiComponentException e) {
                this.logger.warn("Failed to create wiki component(s) for document [{}]: {}", (Object)documentReference, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                break;
            }
        }
    }

    private void unregisterComponents(DocumentReference documentReference) {
        try {
            this.wikiComponentManager.unregisterWikiComponents(documentReference);
        }
        catch (WikiComponentException e) {
            this.logger.warn("Unable to unregister component(s) from document [{}]: {}", (Object)documentReference, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }
}

