/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.configuration.internal;

import java.io.File;
import java.net.URL;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.builder.fluent.PropertiesBuilderParameters;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.configuration.internal.CommonsConfigurationSource;
import org.xwiki.environment.Environment;

@Component
@Named(value="xwikiproperties")
@Singleton
public class XWikiPropertiesConfigurationSource
extends CommonsConfigurationSource
implements Initializable {
    private static final String XWIKI_PROPERTIES_FILE = "xwiki.properties";
    private static final String XWIKI_PROPERTIES_WARPATH = "/WEB-INF/xwiki.properties";
    @Inject
    private Environment environment;
    @Inject
    private Logger logger;

    public void initialize() throws InitializationException {
        this.setConfiguration(this.loadConfiguration());
    }

    private Configuration loadConfiguration() {
        File file = new File("/etc/xwiki/xwiki.properties");
        if (file.exists()) {
            try {
                this.logger.info("Loading [{}] from default location [{}]", (Object)XWIKI_PROPERTIES_FILE, (Object)file.getCanonicalPath());
                return (Configuration)new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)((PropertiesBuilderParameters)new Parameters().properties().setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','))).setFile(file)}).getConfiguration();
            }
            catch (Exception e) {
                this.logger.warn("Failed to load configuration file [{}]: {}", (Object)file, (Object)e.getMessage());
            }
        }
        URL xwikiPropertiesUrl = null;
        try {
            xwikiPropertiesUrl = this.environment.getResource(XWIKI_PROPERTIES_WARPATH);
            if (xwikiPropertiesUrl != null) {
                this.logger.info("Loading [{}] from [{}]", (Object)XWIKI_PROPERTIES_FILE, (Object)xwikiPropertiesUrl.toExternalForm());
                FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)((PropertiesBuilderParameters)new Parameters().properties().setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','))).setURL(xwikiPropertiesUrl)});
                return (Configuration)builder.getConfiguration();
            }
            this.logger.debug("No configuration file [{}] found. Using default configuration values.", (Object)XWIKI_PROPERTIES_WARPATH);
        }
        catch (Exception e) {
            this.logger.warn("Failed to load configuration file [{}]. Using default configuration values. Internal error [{}]", (Object)XWIKI_PROPERTIES_WARPATH, (Object)e.getMessage());
        }
        return new BaseConfiguration();
    }
}

