/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.configuration.internal;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.configuration.internal.AbstractConfigurationSource;
import org.xwiki.model.EntityType;
import org.xwiki.model.ModelConfiguration;
import org.xwiki.model.ModelContext;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.model.reference.WikiReference;

public abstract class AbstractDocumentConfigurationSource
extends AbstractConfigurationSource {
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private ModelContext modelContext;
    @Inject
    private ModelConfiguration modelConfig;

    protected abstract DocumentReference getDocumentReference();

    protected abstract LocalDocumentReference getClassReference();

    protected DocumentAccessBridge getDocumentAccessBridge() {
        return this.documentAccessBridge;
    }

    protected WikiReference getCurrentWikiReference() {
        if (this.modelContext.getCurrentEntityReference() != null) {
            return (WikiReference)this.modelContext.getCurrentEntityReference().extractReference(EntityType.WIKI);
        }
        return new WikiReference(this.modelConfig.getDefaultReferenceValue(EntityType.WIKI));
    }

    public boolean containsKey(String key) {
        Object value = this.getPropertyObject(key);
        return value != null && !"".equals(value);
    }

    public List<String> getKeys() {
        return Collections.emptyList();
    }

    public <T> T getProperty(String key, T defaultValue) {
        T result = this.getProperty(key);
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    public <T> T getProperty(String key, Class<T> valueClass) {
        Object result = this.getProperty(key);
        if (result == null) {
            result = this.getDefault(valueClass);
        }
        return result;
    }

    public <T> T getProperty(String key) {
        return (T)this.getPropertyObject(key);
    }

    private Object getPropertyObject(String key) {
        DocumentReference documentReference = this.getFailsafeDocumentReference();
        LocalDocumentReference classReference = this.getFailsafeClassReference();
        Object result = documentReference != null && classReference != null ? this.getDocumentAccessBridge().getProperty(documentReference, new DocumentReference(classReference, documentReference.getWikiReference()), key) : null;
        return result;
    }

    public boolean isEmpty() {
        return this.getKeys().isEmpty();
    }

    private DocumentReference getFailsafeDocumentReference() {
        DocumentReference documentReference;
        try {
            documentReference = this.getDocumentReference();
        }
        catch (Exception e) {
            documentReference = null;
        }
        return documentReference;
    }

    private LocalDocumentReference getFailsafeClassReference() {
        LocalDocumentReference classReference;
        try {
            classReference = this.getClassReference();
        }
        catch (Exception e) {
            classReference = null;
        }
        return classReference;
    }
}

