/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.configuration.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.event.XObjectAddedEvent;
import com.xpn.xwiki.internal.event.XObjectDeletedEvent;
import com.xpn.xwiki.internal.event.XObjectUpdatedEvent;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.xwiki.bridge.event.WikiDeletedEvent;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheException;
import org.xwiki.cache.CacheManager;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.phase.Disposable;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.configuration.internal.AbstractConfigurationSource;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.model.reference.RegexEntityReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;
import org.xwiki.properties.ConverterManager;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

public abstract class AbstractDocumentConfigurationSource
extends AbstractConfigurationSource
implements Initializable,
Disposable {
    protected static final String NO_VALUE = "---";
    @Inject
    protected WikiDescriptorManager wikiManager;
    @Inject
    protected CacheManager cacheManager;
    @Inject
    protected EntityReferenceSerializer<String> referenceSerializer;
    @Inject
    protected ObservationManager observation;
    @Inject
    protected Provider<XWikiContext> xcontextProvider;
    @Inject
    protected ConverterManager converter;
    @Inject
    protected Logger logger;
    protected Cache<Object> cache;

    protected abstract DocumentReference getDocumentReference();

    protected abstract LocalDocumentReference getClassReference();

    protected abstract String getCacheId();

    protected String getCacheKeyPrefix() {
        return (String)this.referenceSerializer.serialize((EntityReference)this.getDocumentReference(), new Object[0]);
    }

    public void initialize() throws InitializationException {
        try {
            this.cache = this.cacheManager.createNewCache(new CacheConfiguration(this.getCacheId()));
        }
        catch (CacheException e) {
            throw new InitializationException("Failed to initialize cache", (Throwable)e);
        }
        this.observation.addListener(new EventListener(){

            public void onEvent(Event event, Object source, Object data) {
                AbstractDocumentConfigurationSource.this.onCacheCleanup(event, source, data);
            }

            public String getName() {
                return AbstractDocumentConfigurationSource.this.getCacheId();
            }

            public List<Event> getEvents() {
                return AbstractDocumentConfigurationSource.this.getCacheCleanupEvents();
            }
        });
    }

    public void dispose() throws ComponentLifecycleException {
        this.observation.removeListener(this.getCacheId());
    }

    protected List<Event> getCacheCleanupEvents() {
        RegexEntityReference classMatcher = new RegexEntityReference(Pattern.compile(".*:" + (String)this.referenceSerializer.serialize((EntityReference)this.getClassReference(), new Object[0]) + "\\[\\d*\\]"), EntityType.OBJECT);
        return Arrays.asList(new XObjectAddedEvent((EntityReference)classMatcher), new XObjectDeletedEvent((EntityReference)classMatcher), new XObjectUpdatedEvent((EntityReference)classMatcher), new WikiDeletedEvent());
    }

    protected void onCacheCleanup(Event event, Object source, Object data) {
        this.cache.removeAll();
    }

    protected WikiReference getCurrentWikiReference() {
        return new WikiReference(this.wikiManager.getCurrentWikiId());
    }

    public boolean containsKey(String key) {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        if (xcontext != null && xcontext.getWiki() != null) {
            Object value = this.getPropertyValue(key, null);
            return value != null;
        }
        return false;
    }

    protected BaseObject getBaseObject() throws XWikiException {
        DocumentReference documentReference = this.getFailsafeDocumentReference();
        LocalDocumentReference classReference = this.getFailsafeClassReference();
        if (documentReference != null && classReference != null) {
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            XWikiDocument document = xcontext.getWiki().getDocument(this.getDocumentReference(), xcontext);
            return document.getXObject((EntityReference)classReference);
        }
        return null;
    }

    protected Object getBaseProperty(String propertyName, boolean text) throws XWikiException {
        BaseObject baseObject = this.getBaseObject();
        if (baseObject != null) {
            String value;
            BaseProperty property = (BaseProperty)baseObject.getField(propertyName);
            Object object = property != null ? (text ? property.toText() : property.getValue()) : (value = null);
            if (this.isEmpty(value)) {
                value = null;
            }
            return value;
        }
        return null;
    }

    public List<String> getKeys() {
        List<String> keys = Collections.emptyList();
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        if (xcontext != null && xcontext.getWiki() != null) {
            try {
                BaseObject baseObject = this.getBaseObject();
                if (baseObject != null) {
                    Set properties = baseObject.getPropertyList();
                    keys = new ArrayList<String>(properties.size());
                    for (String key : properties) {
                        if (!this.containsKey(key)) continue;
                        keys.add(key);
                    }
                }
            }
            catch (XWikiException e) {
                this.logger.error("Failed to access configuration", (Throwable)e);
            }
        }
        return keys;
    }

    public <T> T getProperty(String key, T defaultValue) {
        Object result = this.getPropertyValue(key, defaultValue != null ? defaultValue.getClass() : null);
        if (result == null) {
            result = defaultValue;
        }
        return (T)result;
    }

    public <T> T getProperty(String key, Class<T> valueClass) {
        Object result = this.getPropertyValue(key, valueClass);
        if (result == null) {
            result = this.getDefault(valueClass);
        }
        return result;
    }

    public <T> T getProperty(String key) {
        return this.getPropertyValue(key, null);
    }

    protected <T> T getPropertyValue(String key, Class<T> valueClass) {
        XWikiContext xcontext;
        String cacheKey = this.getCacheKeyPrefix() + ':' + (valueClass != null ? valueClass.getName() : null) + ':' + key;
        Object result = this.cache.get(cacheKey);
        if (result == null && (xcontext = (XWikiContext)this.xcontextProvider.get()) != null && xcontext.getWiki() != null) {
            try {
                result = this.getBaseProperty(key, valueClass == String.class);
                if (valueClass != null && result != null) {
                    result = this.converter.convert(valueClass, result);
                }
                this.cache.set(cacheKey, result == null ? Void.TYPE : result);
            }
            catch (XWikiException e) {
                this.logger.error("Failed to access configuration property", (Throwable)e);
            }
        }
        if (result == Void.TYPE) {
            result = null;
        }
        return (T)result;
    }

    public boolean isEmpty() {
        return this.getKeys().isEmpty();
    }

    protected DocumentReference getFailsafeDocumentReference() {
        DocumentReference documentReference;
        try {
            documentReference = this.getDocumentReference();
        }
        catch (Exception e) {
            documentReference = null;
        }
        return documentReference;
    }

    protected LocalDocumentReference getFailsafeClassReference() {
        LocalDocumentReference classReference;
        try {
            classReference = this.getClassReference();
        }
        catch (Exception e) {
            classReference = null;
        }
        return classReference;
    }

    protected boolean isEmpty(Object value) {
        return value == null || value instanceof String && (value.equals("") || value.equals(NO_VALUE));
    }
}

