/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.configuration.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.configuration.internal.AbstractCompositeConfigurationSource;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.SpaceReference;

@Component
@Named(value="spaces")
@Singleton
public class SpacesConfigurationSource
extends AbstractCompositeConfigurationSource {
    @Inject
    @Named(value="space")
    private ConfigurationSource spacePreferencesSource;
    @Inject
    private Provider<XWikiContext> xcontextProvider;

    @Override
    public Iterator<ConfigurationSource> iterator() {
        XWikiDocument currentDocument;
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        if (xcontext != null && (currentDocument = xcontext.getDoc()) != null) {
            return new SpaceIterator(currentDocument.getDocumentReference().getLastSpaceReference());
        }
        return Collections.emptyList().iterator();
    }

    private class SpaceConfigurationSource
    implements ConfigurationSource {
        private SpaceReference reference;
        private XWikiDocument document;

        SpaceConfigurationSource(SpaceReference reference) {
            this.reference = reference;
        }

        private XWikiDocument setCurrentDocument(XWikiDocument document) {
            XWikiContext xcontext = (XWikiContext)SpacesConfigurationSource.this.xcontextProvider.get();
            if (xcontext != null) {
                XWikiDocument currentDocument = xcontext.getDoc();
                xcontext.setDoc(document);
                return currentDocument;
            }
            return null;
        }

        public XWikiDocument getDocument() {
            if (this.document == null) {
                this.document = new XWikiDocument(new DocumentReference("WebPreferences", this.reference));
            }
            return this.document;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T getProperty(String key, T defaultValue) {
            XWikiDocument currentDocument = this.setCurrentDocument(this.getDocument());
            try {
                Object object = SpacesConfigurationSource.this.spacePreferencesSource.getProperty(key, defaultValue);
                return (T)object;
            }
            finally {
                this.setCurrentDocument(currentDocument);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T getProperty(String key, Class<T> valueClass) {
            XWikiDocument currentDocument = this.setCurrentDocument(this.getDocument());
            try {
                Object object = SpacesConfigurationSource.this.spacePreferencesSource.getProperty(key, valueClass);
                return (T)object;
            }
            finally {
                this.setCurrentDocument(currentDocument);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T getProperty(String key) {
            XWikiDocument currentDocument = this.setCurrentDocument(this.getDocument());
            try {
                Object object = SpacesConfigurationSource.this.spacePreferencesSource.getProperty(key);
                return (T)object;
            }
            finally {
                this.setCurrentDocument(currentDocument);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<String> getKeys() {
            XWikiDocument currentDocument = this.setCurrentDocument(this.getDocument());
            try {
                List list = SpacesConfigurationSource.this.spacePreferencesSource.getKeys();
                return list;
            }
            finally {
                this.setCurrentDocument(currentDocument);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsKey(String key) {
            XWikiDocument currentDocument = this.setCurrentDocument(this.getDocument());
            try {
                boolean bl = SpacesConfigurationSource.this.spacePreferencesSource.containsKey(key);
                return bl;
            }
            finally {
                this.setCurrentDocument(currentDocument);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            XWikiDocument currentDocument = this.setCurrentDocument(this.getDocument());
            try {
                boolean bl = SpacesConfigurationSource.this.spacePreferencesSource.isEmpty();
                return bl;
            }
            finally {
                this.setCurrentDocument(currentDocument);
            }
        }
    }

    private class SpaceIterator
    implements Iterator<ConfigurationSource> {
        private SpaceReference reference;

        SpaceIterator(SpaceReference reference) {
            this.reference = reference;
        }

        @Override
        public boolean hasNext() {
            return this.reference != null;
        }

        @Override
        public ConfigurationSource next() {
            SpaceReference next = this.reference;
            if (this.reference != null) {
                this.reference = this.reference.getParent() instanceof SpaceReference ? (SpaceReference)this.reference.getParent() : null;
                return new SpaceConfigurationSource(next);
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

