/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.container.internal;

import java.util.List;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.component.logging.AbstractLogEnabled;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.container.ApplicationContext;
import org.xwiki.container.ApplicationContextListener;
import org.xwiki.container.ApplicationContextListenerManager;

@Component
public class DefaultApplicationContextListenerManager
extends AbstractLogEnabled
implements ApplicationContextListenerManager {
    @Requirement
    private ComponentManager componentManager;

    public void initializeApplicationContext(ApplicationContext applicationContext) {
        try {
            List initializers = this.componentManager.lookupList(ApplicationContextListener.class);
            for (ApplicationContextListener initializer : initializers) {
                initializer.initializeApplicationContext(applicationContext);
            }
        }
        catch (ComponentLookupException ex) {
            this.getLogger().error(ex.getMessage(), (Throwable)ex);
        }
    }

    public void destroyApplicationContext(ApplicationContext applicationContext) {
        try {
            List initializers = this.componentManager.lookupList(ApplicationContextListener.class);
            for (ApplicationContextListener initializer : initializers) {
                initializer.destroyApplicationContext(applicationContext);
            }
        }
        catch (ComponentLookupException ex) {
            this.getLogger().error(ex.getMessage(), (Throwable)ex);
        }
    }
}

