/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.container;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.container.ApplicationContext;

public abstract class AbstractApplicationContext
implements ApplicationContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractApplicationContext.class);
    private static final String PROPERTY_PERSISTENTDIRECTORY = "container.persistentDirectory";
    private final ComponentManager componentManager;
    private File permanentDirectory;

    public AbstractApplicationContext(ComponentManager componentManager) {
        this.componentManager = componentManager;
    }

    @Override
    public File getPermanentDirectory() {
        if (this.permanentDirectory == null) {
            try {
                this.permanentDirectory = this.getConfiguredPermanentDirectory();
            }
            catch (Exception e) {
                LOGGER.error("Failed to get configured permanent directory", (Throwable)e);
            }
            if (this.permanentDirectory == null) {
                this.permanentDirectory = this.getTemporaryDirectory();
            }
        }
        return this.permanentDirectory;
    }

    private File getConfiguredPermanentDirectory() throws ComponentLookupException {
        File directory = null;
        String directoryName = (String)((ConfigurationSource)this.componentManager.lookup(ConfigurationSource.class, "xwikiproperties")).getProperty(PROPERTY_PERSISTENTDIRECTORY);
        if (directoryName != null) {
            directory = new File(directoryName);
            if (directory.exists()) {
                if (!directory.isDirectory()) {
                    LOGGER.error("Configured permanent storage directory [{}] is not a directory", (Object)directory.getAbsolutePath());
                    directory = null;
                } else if (!directory.canWrite()) {
                    LOGGER.error("Configured permanent storage directory [{}] is not writable", (Object)directory.getAbsolutePath());
                    directory = null;
                }
            } else {
                directory.mkdirs();
            }
        }
        return directory;
    }
}

