/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.container.servlet.filters;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;

public final class SavedRequestManager {
    private static final String SAVED_REQUESTS_IDENTIFIER = "srid";
    private static final String SAVED_REQUESTS_KEY = SavedRequest.class.getCanonicalName() + "_SavedRequests";

    private SavedRequestManager() {
    }

    public static String getSavedRequestIdentifier() {
        return SAVED_REQUESTS_IDENTIFIER;
    }

    public static String getSavedRequestKey() {
        return SAVED_REQUESTS_KEY;
    }

    public static String saveRequest(HttpServletRequest request) {
        String key;
        HttpSession session = request.getSession();
        HashMap<String, SavedRequest> savedRequests = (HashMap<String, SavedRequest>)session.getAttribute(SavedRequestManager.getSavedRequestKey());
        if (savedRequests == null) {
            savedRequests = new HashMap<String, SavedRequest>();
            session.setAttribute(SavedRequestManager.getSavedRequestKey(), savedRequests);
        }
        SavedRequest savedRequest = new SavedRequest(request);
        while (savedRequests.containsKey(key = RandomStringUtils.randomAlphanumeric((int)8))) {
        }
        savedRequests.put(key, savedRequest);
        return key;
    }

    public static String getOriginalUrl(HttpServletRequest request) {
        SavedRequest savedRequest;
        String identifier;
        HttpSession session = request.getSession();
        Map savedRequests = (Map)session.getAttribute(SavedRequestManager.getSavedRequestKey());
        if (savedRequests != null && !StringUtils.isEmpty((String)(identifier = request.getParameter(SavedRequestManager.getSavedRequestIdentifier()))) && (savedRequest = (SavedRequest)savedRequests.get(request.getParameter(SavedRequestManager.getSavedRequestIdentifier()))) != null) {
            return savedRequest.getRequestUrl() + "?srid=" + identifier;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SavedRequest {
        private Map<String, String[]> parameters;
        private String requestUrl;

        public SavedRequest(HttpServletRequest request) {
            this.parameters = new HashMap<String, String[]>(request.getParameterMap());
            this.requestUrl = request.getRequestURL().toString();
        }

        public String getParameter(String name) {
            String[] values = this.parameters.get(name);
            if (values != null && values.length > 0) {
                return values[0];
            }
            return null;
        }

        public String[] getParameterValues(String name) {
            return this.parameters.get(name);
        }

        public Map<String, String[]> getParameterMap() {
            return this.parameters;
        }

        public String getRequestUrl() {
            return this.requestUrl;
        }
    }
}

