/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.container.servlet.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.container.ApplicationContext;
import org.xwiki.container.ApplicationContextListenerManager;
import org.xwiki.container.Container;
import org.xwiki.container.Request;
import org.xwiki.container.RequestInitializerManager;
import org.xwiki.container.Response;
import org.xwiki.container.Session;
import org.xwiki.container.servlet.ServletApplicationContext;
import org.xwiki.container.servlet.ServletContainerException;
import org.xwiki.container.servlet.ServletContainerInitializer;
import org.xwiki.container.servlet.ServletRequest;
import org.xwiki.container.servlet.ServletResponse;
import org.xwiki.container.servlet.ServletSession;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.context.ExecutionContextManager;
import org.xwiki.url.InvalidURLException;
import org.xwiki.url.XWikiURL;
import org.xwiki.url.XWikiURLFactory;

@Component
public class DefaultServletContainerInitializer
implements ServletContainerInitializer {
    @Requirement
    private ApplicationContextListenerManager applicationContextListenerManager;
    @Requirement
    private Container container;
    @Requirement
    private Execution execution;
    @Requirement
    private ComponentManager componentManager;
    @Inject
    private Logger logger;

    @Override
    public void initializeApplicationContext(ServletContext servletContext) {
        ServletApplicationContext applicationContext = new ServletApplicationContext(servletContext);
        this.container.setApplicationContext((ApplicationContext)applicationContext);
        this.applicationContextListenerManager.initializeApplicationContext((ApplicationContext)applicationContext);
    }

    @Override
    public void initializeRequest(HttpServletRequest httpServletRequest, Object xwikiContext) throws ServletContainerException {
        RequestInitializerManager manager;
        this.container.setRequest((Request)new ServletRequest(httpServletRequest));
        this.execution.setContext(new ExecutionContext());
        if (xwikiContext != null) {
            this.execution.getContext().setProperty("xwikicontext", xwikiContext);
        }
        try {
            URL url = this.getURL(httpServletRequest);
            XWikiURLFactory urlFactory = (XWikiURLFactory)this.componentManager.lookup(XWikiURLFactory.class);
            XWikiURL xwikiURL = urlFactory.createURL((Object)url, Collections.singletonMap("ignorePrefix", httpServletRequest.getContextPath()));
            this.container.getRequest().setProperty("xwikiurl", (Object)xwikiURL);
        }
        catch (MalformedURLException mue) {
            this.logger.debug("Failed to get URL from HTTP Request", (Throwable)mue);
        }
        catch (ComponentLookupException cle) {
            throw new ServletContainerException("Failed to locate URL Factory", cle);
        }
        catch (InvalidURLException iue) {
            this.logger.debug("Failed to extract XWiki URL", (Throwable)iue);
        }
        try {
            manager = (RequestInitializerManager)this.componentManager.lookup(RequestInitializerManager.class);
            manager.initializeRequest(this.container.getRequest());
        }
        catch (Exception e) {
            throw new ServletContainerException("Failed to initialize request", e);
        }
        try {
            manager = (ExecutionContextManager)this.componentManager.lookup(ExecutionContextManager.class);
            manager.initialize(this.execution.getContext());
        }
        catch (Exception e) {
            throw new ServletContainerException("Failed to initialize Execution Context", e);
        }
    }

    @Override
    public void initializeRequest(HttpServletRequest httpServletRequest) throws ServletContainerException {
        this.initializeRequest(httpServletRequest, null);
    }

    @Override
    public void initializeResponse(HttpServletResponse httpServletResponse) {
        this.container.setResponse((Response)new ServletResponse(httpServletResponse));
    }

    @Override
    public void initializeSession(HttpServletRequest httpServletRequest) {
        this.container.setSession((Session)new ServletSession(httpServletRequest));
    }

    private URL getURL(HttpServletRequest httpServletRequest) throws MalformedURLException {
        StringBuffer url = httpServletRequest.getRequestURL();
        if (httpServletRequest.getQueryString() != null) {
            url.append('?');
            url.append(httpServletRequest.getQueryString());
        }
        return new URL(url.toString());
    }
}

