/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.cipher.internal.asymmetric;

import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.BufferedAsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.xwiki.crypto.cipher.AsymmetricCipher;

public class BcBufferedAsymmetricCipher
implements AsymmetricCipher {
    private static final RuntimeException NO_STREAMING_ERROR = new UnsupportedOperationException("Asymmetric cipher does not support being streamed.");
    private final BufferedAsymmetricBlockCipher cipher;
    private final boolean forEncryption;
    private final String algorithmName;

    public BcBufferedAsymmetricCipher(AsymmetricBlockCipher cipher, boolean forEncryption, CipherParameters parameters, String algorithmName) {
        this.cipher = new BufferedAsymmetricBlockCipher(cipher);
        this.forEncryption = forEncryption;
        this.algorithmName = algorithmName;
        this.cipher.init(forEncryption, parameters);
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    @Override
    public int getInputBlockSize() {
        return this.cipher.getInputBlockSize();
    }

    @Override
    public int getOutputBlockSize() {
        return this.cipher.getOutputBlockSize();
    }

    @Override
    public boolean isForEncryption() {
        return this.forEncryption;
    }

    @Override
    public FilterInputStream getInputStream(InputStream is) {
        throw NO_STREAMING_ERROR;
    }

    @Override
    public FilterOutputStream getOutputStream(OutputStream os) {
        throw NO_STREAMING_ERROR;
    }

    @Override
    public byte[] update(byte[] input) {
        if (input != null) {
            return this.update(input, 0, input.length);
        }
        return null;
    }

    @Override
    public byte[] update(byte[] input, int inputOffset, int inputLen) {
        this.cipher.processBytes(input, inputOffset, inputLen);
        return null;
    }

    @Override
    public byte[] doFinal() throws GeneralSecurityException {
        return this.doFinal(null, 0, 0);
    }

    @Override
    public byte[] doFinal(byte[] input) throws GeneralSecurityException {
        if (input != null) {
            return this.doFinal(input, 0, input.length);
        }
        return this.doFinal(null, 0, 0);
    }

    @Override
    public byte[] doFinal(byte[] input, int inputOffset, int inputLen) throws GeneralSecurityException {
        if (input != null) {
            this.cipher.processBytes(input, inputOffset, inputLen);
        }
        try {
            return this.cipher.doFinal();
        }
        catch (InvalidCipherTextException e) {
            throw new GeneralSecurityException("Cipher failed to process data.", e);
        }
    }
}

