/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.internal;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LineWrapperOutputStream
extends FilterOutputStream {
    private static final byte[] NEWLINE = System.getProperty("line.separator", "\n").getBytes();
    private byte[] oneByte = new byte[1];
    private final int wrapAt;
    private int count;

    public LineWrapperOutputStream(OutputStream outputStream, int wrapAt) {
        super(outputStream);
        this.wrapAt = wrapAt;
        this.count = 0;
    }

    @Override
    public void write(byte[] bytes, int offset, int length) throws IOException {
        if ((offset | length | bytes.length - (length + offset) | offset + length) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (length > 0) {
            if (this.count + length >= this.wrapAt) {
                int off = offset;
                int len = length;
                int curlen = this.wrapAt - this.count;
                do {
                    this.out.write(bytes, off, curlen);
                    this.out.write(NEWLINE, 0, NEWLINE.length);
                    off += curlen;
                } while ((curlen = (len -= curlen) > this.wrapAt ? this.wrapAt : len) == this.wrapAt);
                if (curlen > 0) {
                    this.out.write(bytes, off, curlen);
                }
                this.count = curlen;
            } else {
                this.count += length;
                this.out.write(bytes, offset, length);
            }
        }
    }

    @Override
    public void write(int i) throws IOException {
        this.oneByte[0] = (byte)i;
        this.write(this.oneByte, 0, 1);
    }
}

