/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.params.cipher.symmetric;

import java.security.SecureRandom;
import org.xwiki.crypto.params.cipher.symmetric.KeyParameter;
import org.xwiki.crypto.params.cipher.symmetric.SymmetricCipherParameters;
import org.xwiki.stability.Unstable;

@Unstable
public class KeyWithIVParameters
implements SymmetricCipherParameters {
    private final KeyParameter keyParam;
    private final byte[] iv;

    public KeyWithIVParameters(byte[] key, int ivSize) {
        this(new KeyParameter(key), ivSize);
    }

    public KeyWithIVParameters(byte[] key, byte[] iv) {
        this(new KeyParameter(key), iv);
    }

    public KeyWithIVParameters(byte[] key, int ivSize, SecureRandom random) {
        this(new KeyParameter(key), ivSize, random);
    }

    public KeyWithIVParameters(KeyParameter key, int ivSize) {
        this(key, ivSize, new SecureRandom());
    }

    public KeyWithIVParameters(KeyParameter key, int ivSize, SecureRandom random) {
        this.keyParam = key;
        this.iv = new byte[ivSize];
        random.nextBytes(this.iv);
    }

    public KeyWithIVParameters(KeyParameter key, byte[] iv) {
        this.keyParam = key;
        this.iv = iv;
    }

    public KeyParameter getKeyParameter() {
        return this.keyParam;
    }

    public byte[] getKey() {
        return this.keyParam.getKey();
    }

    public byte[] getIV() {
        return this.iv;
    }
}

