/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.params.generator.asymmetric;

import java.math.BigInteger;
import org.xwiki.crypto.params.generator.KeyGenerationParameters;
import org.xwiki.crypto.params.generator.symmetric.GenericKeyGenerationParameters;

public class RSAKeyGenerationParameters
extends GenericKeyGenerationParameters
implements KeyGenerationParameters {
    private static final BigInteger DEFAULT_PUBLIC_EXPONENT = BigInteger.valueOf(65537L);
    private static final int DEFAULT_CERTAINTY = 12;
    private static final int DEFAULT_STRENGTH = 256;
    private final BigInteger publicExponent;
    private final int certainty;

    public RSAKeyGenerationParameters() {
        this(256);
    }

    public RSAKeyGenerationParameters(int strength) {
        this(strength, DEFAULT_PUBLIC_EXPONENT, 12);
    }

    public RSAKeyGenerationParameters(int strength, BigInteger publicExponent) {
        this(strength, publicExponent, 12);
    }

    public RSAKeyGenerationParameters(int strength, int certainty) {
        this(strength, DEFAULT_PUBLIC_EXPONENT, certainty);
    }

    public RSAKeyGenerationParameters(int strength, BigInteger publicExponent, int certainty) {
        super(strength);
        this.publicExponent = publicExponent;
        this.certainty = certainty;
    }

    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    public int getCertainty() {
        return this.certainty;
    }
}

