/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.pkix;

import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import org.xwiki.crypto.params.cipher.CipherParameters;
import org.xwiki.crypto.pkix.params.CertifiedKeyPair;
import org.xwiki.crypto.pkix.params.CertifiedPublicKey;
import org.xwiki.crypto.signer.Signer;
import org.xwiki.crypto.signer.SignerFactory;
import org.xwiki.stability.Unstable;

@Unstable
public final class CertifyingSigner
implements Signer {
    private final CertifiedPublicKey certifier;
    private final Signer signer;

    private CertifyingSigner(CertifiedPublicKey certifier, Signer signer) {
        this.certifier = certifier;
        this.signer = signer;
    }

    public static CertifyingSigner getInstance(boolean forSigning, CertifiedKeyPair certifier, SignerFactory factory) {
        return new CertifyingSigner(certifier.getCertificate(), factory.getInstance(forSigning, (CipherParameters)certifier.getPrivateKey()));
    }

    public CertifiedPublicKey getCertifier() {
        return this.certifier;
    }

    public String getAlgorithmName() {
        return this.signer.getAlgorithmName();
    }

    public boolean isForSigning() {
        return this.signer.isForSigning();
    }

    public FilterInputStream getInputStream(InputStream is) {
        return this.signer.getInputStream(is);
    }

    public OutputStream getOutputStream() {
        return this.signer.getOutputStream();
    }

    public void update(byte input) {
        this.signer.update(input);
    }

    public void update(byte[] input) {
        this.signer.update(input);
    }

    public void update(byte[] input, int inputOffset, int inputLen) {
        this.signer.update(input, inputOffset, inputLen);
    }

    public byte[] generate() throws GeneralSecurityException {
        return this.signer.generate();
    }

    public byte[] generate(byte[] input) throws GeneralSecurityException {
        return this.signer.generate(input);
    }

    public byte[] generate(byte[] input, int inputOffset, int inputLen) throws GeneralSecurityException {
        return this.signer.generate(input, inputOffset, inputLen);
    }

    public boolean verify(byte[] signature) throws GeneralSecurityException {
        return this.signer.verify(signature);
    }

    public boolean verify(byte[] signature, byte[] input) throws GeneralSecurityException {
        return this.signer.verify(signature, input);
    }

    public boolean verify(byte[] signature, int signOffset, int signLen, byte[] input, int inputOffset, int inputLen) throws GeneralSecurityException {
        return this.signer.verify(signature, signOffset, signLen, input, inputOffset, inputLen);
    }

    public byte[] getEncoded() {
        return this.signer.getEncoded();
    }
}

