/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.pkix.internal;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.Calendar;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x509.TBSCertificate;
import org.xwiki.crypto.params.cipher.asymmetric.PublicKeyParameters;
import org.xwiki.crypto.pkix.CertificateGenerator;
import org.xwiki.crypto.pkix.CertifyingSigner;
import org.xwiki.crypto.pkix.internal.BcUtils;
import org.xwiki.crypto.pkix.internal.BcX509CertifiedPublicKey;
import org.xwiki.crypto.pkix.internal.X509TBSCertificateBuilder;
import org.xwiki.crypto.pkix.params.CertificateParameters;
import org.xwiki.crypto.pkix.params.CertifiedPublicKey;
import org.xwiki.crypto.pkix.params.PrincipalIndentifier;
import org.xwiki.crypto.pkix.params.x509certificate.X509CertificateGenerationParameters;
import org.xwiki.crypto.pkix.params.x509certificate.X509CertificateParameters;
import org.xwiki.crypto.signer.Signer;
import org.xwiki.crypto.signer.SignerFactory;

public abstract class AbstractBcX509CertificateGenerator
implements CertificateGenerator {
    private final Signer signer;
    private final int validity;
    private final SignerFactory signerFactory;
    private final SecureRandom random;

    public AbstractBcX509CertificateGenerator(Signer signer, X509CertificateGenerationParameters parameters, SignerFactory signerFactory, SecureRandom random) {
        this.signer = signer;
        this.validity = parameters.getValidity();
        this.signerFactory = signerFactory;
        this.random = random;
    }

    protected abstract X509TBSCertificateBuilder getTBSCertificateBuilder();

    protected void extendsTBSCertificate(X509TBSCertificateBuilder builder, CertifiedPublicKey issuer, PrincipalIndentifier subjectName, PublicKeyParameters subject, X509CertificateParameters parameters) throws IOException {
    }

    public TBSCertificate buildTBSCertificate(PrincipalIndentifier subjectName, PublicKeyParameters subject, X509CertificateParameters parameters) throws IOException {
        PrincipalIndentifier issuerName;
        CertifiedPublicKey issuer = null;
        if (this.signer instanceof CertifyingSigner) {
            issuer = ((CertifyingSigner)this.signer).getCertifier();
            issuerName = issuer.getIssuer();
        } else {
            issuerName = subjectName;
        }
        X509TBSCertificateBuilder builder = this.getTBSCertificateBuilder();
        builder.setSerialNumber(new BigInteger(128, this.random)).setIssuer(issuerName);
        this.addValidityDates(builder);
        this.extendsTBSCertificate(builder, issuer, subjectName, subject, parameters);
        return builder.setSubject(subjectName).setSubjectPublicKeyInfo(subject).setSignature(this.signer).build();
    }

    @Override
    public CertifiedPublicKey generate(PrincipalIndentifier subjectName, PublicKeyParameters subject, CertificateParameters parameters) throws IOException, GeneralSecurityException {
        if (!(parameters instanceof X509CertificateParameters)) {
            throw new IllegalArgumentException("Invalid parameters for X.509 certificate: " + parameters.getClass().getName());
        }
        TBSCertificate tbsCert = this.buildTBSCertificate(subjectName, subject, (X509CertificateParameters)parameters);
        return new BcX509CertifiedPublicKey(BcUtils.getX509CertificateHolder(tbsCert, BcUtils.updateDEREncodedObject(this.signer, (ASN1Encodable)tbsCert).generate()), this.signerFactory);
    }

    private void addValidityDates(X509TBSCertificateBuilder builder) {
        Calendar cal = Calendar.getInstance();
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        builder.setStartDate(cal.getTime());
        cal.add(5, this.validity);
        builder.setEndDate(cal.getTime());
    }
}

