/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.pkix.internal.extension;

import java.util.EnumSet;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.cert.bc.BcX509ExtensionUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.crypto.params.cipher.asymmetric.PublicKeyParameters;
import org.xwiki.crypto.pkix.X509ExtensionBuilder;
import org.xwiki.crypto.pkix.internal.BcUtils;
import org.xwiki.crypto.pkix.internal.extension.AbstractBcX509ExtensionBuilder;
import org.xwiki.crypto.pkix.internal.extension.BcExtensionUtils;
import org.xwiki.crypto.pkix.params.CertifiedPublicKey;
import org.xwiki.crypto.pkix.params.x509certificate.extension.ExtendedKeyUsages;
import org.xwiki.crypto.pkix.params.x509certificate.extension.KeyUsage;
import org.xwiki.crypto.pkix.params.x509certificate.extension.X509GeneralName;

@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class DefaultX509ExtensionBuilder
extends AbstractBcX509ExtensionBuilder {
    @Override
    public X509ExtensionBuilder addBasicConstraints(boolean isCertificateAuthority) {
        return this.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(isCertificateAuthority));
    }

    @Override
    public X509ExtensionBuilder addBasicConstraints(int pathLen) {
        return this.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(pathLen));
    }

    @Override
    public X509ExtensionBuilder addKeyUsage(EnumSet<KeyUsage> usages) {
        return this.addKeyUsage(true, usages);
    }

    @Override
    public X509ExtensionBuilder addKeyUsage(boolean critical, EnumSet<KeyUsage> usages) {
        if (usages == null || usages.isEmpty()) {
            return this;
        }
        return this.addExtension(Extension.keyUsage, critical, (ASN1Encodable)BcExtensionUtils.getKeyUsage(usages));
    }

    @Override
    public X509ExtensionBuilder addExtendedKeyUsage(boolean critical, ExtendedKeyUsages usages) {
        if (usages == null || usages.isEmpty()) {
            return this;
        }
        return this.addExtension(Extension.extendedKeyUsage, critical, (ASN1Encodable)BcExtensionUtils.getExtendedKeyUsage(usages.getAll()));
    }

    @Override
    public X509ExtensionBuilder addAuthorityKeyIdentifier(CertifiedPublicKey issuer) {
        if (issuer == null) {
            return this;
        }
        return this.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)new BcX509ExtensionUtils().createAuthorityKeyIdentifier(BcUtils.getX509CertificateHolder(issuer)));
    }

    @Override
    public X509ExtensionBuilder addAuthorityKeyIdentifier(PublicKeyParameters subject) {
        if (subject == null) {
            return this;
        }
        return this.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)new BcX509ExtensionUtils().createAuthorityKeyIdentifier(BcUtils.getSubjectPublicKeyInfo(subject)));
    }

    @Override
    public X509ExtensionBuilder addSubjectKeyIdentifier(PublicKeyParameters subject) {
        if (subject == null) {
            return this;
        }
        return this.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)new BcX509ExtensionUtils().createSubjectKeyIdentifier(BcUtils.getSubjectPublicKeyInfo(subject)));
    }

    @Override
    public X509ExtensionBuilder addSubjectAltName(boolean critical, X509GeneralName[] names) {
        if (names == null) {
            return this;
        }
        return this.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)BcExtensionUtils.getGeneralNames(names));
    }

    @Override
    public X509ExtensionBuilder addIssuerAltName(X509GeneralName[] names) {
        if (names == null) {
            return this;
        }
        return this.addExtension(Extension.issuerAlternativeName, false, (ASN1Encodable)BcExtensionUtils.getGeneralNames(names));
    }
}

