/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.pkix.internal;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.x509.TBSCertificate;
import org.bouncycastle.asn1.x509.Time;
import org.bouncycastle.asn1.x509.V3TBSCertificateGenerator;
import org.xwiki.crypto.params.cipher.asymmetric.PublicKeyParameters;
import org.xwiki.crypto.pkix.internal.BcUtils;
import org.xwiki.crypto.pkix.internal.X509TBSCertificateBuilder;
import org.xwiki.crypto.pkix.internal.extension.BcX509Extensions;
import org.xwiki.crypto.pkix.internal.extension.DefaultX509ExtensionBuilder;
import org.xwiki.crypto.pkix.params.CertifiedPublicKey;
import org.xwiki.crypto.pkix.params.PrincipalIndentifier;
import org.xwiki.crypto.pkix.params.x509certificate.extension.X509Extensions;
import org.xwiki.crypto.signer.Signer;

public class BcX509v3TBSCertificateBuilder
implements X509TBSCertificateBuilder {
    private final V3TBSCertificateGenerator tbsGen = new V3TBSCertificateGenerator();

    @Override
    public X509TBSCertificateBuilder setSerialNumber(BigInteger serial) {
        this.tbsGen.setSerialNumber(new ASN1Integer(serial));
        return this;
    }

    @Override
    public X509TBSCertificateBuilder setSubjectPublicKeyInfo(PublicKeyParameters subject) {
        this.tbsGen.setSubjectPublicKeyInfo(BcUtils.getSubjectPublicKeyInfo(subject));
        return this;
    }

    @Override
    public X509TBSCertificateBuilder setIssuer(PrincipalIndentifier issuer) {
        this.tbsGen.setIssuer(BcUtils.getX500Name(issuer));
        return this;
    }

    @Override
    public X509TBSCertificateBuilder setSubject(PrincipalIndentifier subject) {
        this.tbsGen.setSubject(BcUtils.getX500Name(subject));
        return this;
    }

    @Override
    public X509TBSCertificateBuilder setStartDate(Date time) {
        this.tbsGen.setStartDate(new Time(time));
        return this;
    }

    @Override
    public X509TBSCertificateBuilder setEndDate(Date time) {
        this.tbsGen.setEndDate(new Time(time));
        return this;
    }

    @Override
    public X509TBSCertificateBuilder setSignature(Signer signer) {
        this.tbsGen.setSignature(BcUtils.getSignerAlgoritmIdentifier(signer));
        return this;
    }

    @Override
    public TBSCertificate build() {
        return this.tbsGen.generateTBSCertificate();
    }

    public BcX509v3TBSCertificateBuilder setExtensions(PublicKeyParameters subject, X509Extensions extensions1, X509Extensions extensions2) throws IOException {
        DefaultX509ExtensionBuilder extBuilder = new DefaultX509ExtensionBuilder();
        extBuilder.addAuthorityKeyIdentifier(subject).addSubjectKeyIdentifier(subject).addExtensions(extensions1).addExtensions(extensions2);
        if (!extBuilder.isEmpty()) {
            this.tbsGen.setExtensions(((BcX509Extensions)extBuilder.build()).getExtensions());
        }
        return this;
    }

    public BcX509v3TBSCertificateBuilder setExtensions(CertifiedPublicKey issuer, PublicKeyParameters subject, X509Extensions extensions1, X509Extensions extensions2) throws IOException {
        DefaultX509ExtensionBuilder extBuilder = new DefaultX509ExtensionBuilder();
        extBuilder.addAuthorityKeyIdentifier(issuer).addSubjectKeyIdentifier(subject).addExtensions(extensions1).addExtensions(extensions2);
        if (!extBuilder.isEmpty()) {
            this.tbsGen.setExtensions(((BcX509Extensions)extBuilder.build()).getExtensions());
        }
        return this;
    }
}

