/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.pkix.internal.extension;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.List;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.X509Extension;
import org.xwiki.crypto.pkix.internal.extension.BcExtensionUtils;
import org.xwiki.crypto.pkix.params.x509certificate.extension.ExtendedKeyUsages;
import org.xwiki.crypto.pkix.params.x509certificate.extension.KeyUsage;
import org.xwiki.crypto.pkix.params.x509certificate.extension.X509Extensions;
import org.xwiki.crypto.pkix.params.x509certificate.extension.X509GeneralName;

public class BcX509Extensions
implements X509Extensions {
    private final Extensions extensions;

    public BcX509Extensions(Extensions extensions) {
        this.extensions = extensions;
    }

    public Extensions getExtensions() {
        return this.extensions;
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        Extension ext = this.extensions.getExtension(new ASN1ObjectIdentifier(oid));
        if (ext == null) {
            return null;
        }
        return ext.getExtnValue().getOctets();
    }

    @Override
    public boolean isCritical(String oid) {
        Extension ext = this.extensions.getExtension(new ASN1ObjectIdentifier(oid));
        return ext != null && ext.isCritical();
    }

    @Override
    public String[] getExtensionOID() {
        ArrayList<String> oids = new ArrayList<String>();
        Enumeration extOids = this.extensions.oids();
        while (extOids.hasMoreElements()) {
            oids.add(((ASN1ObjectIdentifier)extOids.nextElement()).getId());
        }
        return oids.toArray(new String[oids.size()]);
    }

    @Override
    public String[] getCriticalExtensionOID() {
        ASN1ObjectIdentifier[] asnoids = this.extensions.getCriticalExtensionOIDs();
        return this.toStringArray(asnoids);
    }

    @Override
    public String[] getNonCriticalExtensionOID() {
        ASN1ObjectIdentifier[] asnoids = this.extensions.getNonCriticalExtensionOIDs();
        return this.toStringArray(asnoids);
    }

    private String[] toStringArray(ASN1ObjectIdentifier[] asnoids) {
        String[] oids = new String[asnoids.length];
        for (int i = 0; i < asnoids.length; ++i) {
            oids[i] = asnoids[i].getId();
        }
        return oids;
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.extensions.getEncoded();
    }

    @Override
    public boolean hasCertificateAuthorityBasicConstraints() {
        BasicConstraints bc = BasicConstraints.fromExtensions((Extensions)this.extensions);
        return bc != null && bc.isCA();
    }

    @Override
    public int getBasicConstraintsPathLen() {
        BasicConstraints bc = BasicConstraints.fromExtensions((Extensions)this.extensions);
        return bc != null ? bc.getPathLenConstraint().intValue() : -1;
    }

    @Override
    public EnumSet<KeyUsage> getKeyUsage() {
        return BcExtensionUtils.getSetOfKeyUsage(org.bouncycastle.asn1.x509.KeyUsage.fromExtensions((Extensions)this.extensions));
    }

    @Override
    public ExtendedKeyUsages getExtendedKeyUsage() {
        return BcExtensionUtils.getExtendedKeyUsages(ExtendedKeyUsage.fromExtensions((Extensions)this.extensions));
    }

    @Override
    public byte[] getAuthorityKeyIdentifier() {
        AuthorityKeyIdentifier id = AuthorityKeyIdentifier.fromExtensions((Extensions)this.extensions);
        return id != null ? id.getKeyIdentifier() : null;
    }

    @Override
    public byte[] getSubjectKeyIdentifier() {
        SubjectKeyIdentifier id = SubjectKeyIdentifier.fromExtensions((Extensions)this.extensions);
        return id != null ? id.getKeyIdentifier() : null;
    }

    @Override
    public List<X509GeneralName> getSubjectAltName() {
        return BcExtensionUtils.getX509GeneralNames(GeneralNames.fromExtensions((Extensions)this.extensions, (ASN1ObjectIdentifier)X509Extension.subjectAlternativeName));
    }

    @Override
    public List<X509GeneralName> getIssuerAltName() {
        return BcExtensionUtils.getX509GeneralNames(GeneralNames.fromExtensions((Extensions)this.extensions, (ASN1ObjectIdentifier)X509Extension.issuerAlternativeName));
    }
}

