/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.signer.internal;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.SignatureException;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.io.SignerInputStream;
import org.bouncycastle.crypto.io.SignerOutputStream;
import org.xwiki.crypto.signer.Signer;

public class BcSigner
implements Signer {
    protected final org.bouncycastle.crypto.Signer signer;
    protected final String signerAlgorithm;
    protected final boolean forSigning;
    protected AlgorithmIdentifier signerAlgorithmIdentifier;

    public BcSigner(org.bouncycastle.crypto.Signer signer, boolean forSigning, CipherParameters parameters, String signerAlgorithm, AlgorithmIdentifier signerAlgId) {
        this.signer = signer;
        this.signerAlgorithm = signerAlgorithm;
        this.forSigning = forSigning;
        this.signerAlgorithmIdentifier = signerAlgId;
        signer.init(forSigning, parameters);
    }

    @Override
    public String getAlgorithmName() {
        return this.signerAlgorithm;
    }

    public AlgorithmIdentifier getSignerAlgorithmIdentifier() {
        return this.signerAlgorithmIdentifier;
    }

    @Override
    public boolean isForSigning() {
        return this.forSigning;
    }

    @Override
    public FilterInputStream getInputStream(InputStream is) {
        this.signer.reset();
        return new SignerInputStream(is, this.signer);
    }

    @Override
    public OutputStream getOutputStream() {
        this.signer.reset();
        return new SignerOutputStream(this.signer);
    }

    @Override
    public void update(byte input) {
        this.signer.update(input);
    }

    @Override
    public void update(byte[] input) {
        this.signer.update(input, 0, input.length);
    }

    @Override
    public void update(byte[] input, int inputOffset, int inputLen) {
        this.signer.update(input, inputOffset, inputLen);
    }

    @Override
    public byte[] generate() throws GeneralSecurityException {
        try {
            return this.signer.generateSignature();
        }
        catch (CryptoException e) {
            throw new SignatureException(e);
        }
    }

    @Override
    public byte[] generate(byte[] input) throws GeneralSecurityException {
        this.update(input);
        return this.generate();
    }

    @Override
    public byte[] generate(byte[] input, int inputOffset, int inputLen) throws GeneralSecurityException {
        this.update(input, inputOffset, inputLen);
        return this.generate();
    }

    @Override
    public boolean verify(byte[] signature) throws GeneralSecurityException {
        return this.signer.verifySignature(signature);
    }

    @Override
    public boolean verify(byte[] signature, byte[] input) throws GeneralSecurityException {
        this.update(input);
        return this.verify(signature);
    }

    @Override
    public boolean verify(byte[] signature, int signOffset, int signLen, byte[] input, int inputOffset, int inputLen) throws GeneralSecurityException {
        this.update(input, inputOffset, inputLen);
        if (signOffset != 0 || signLen != signature.length) {
            byte[] sign = new byte[signLen];
            System.arraycopy(signature, signOffset, sign, 0, signLen);
            return this.verify(sign);
        }
        return this.verify(signature);
    }

    @Override
    public byte[] getEncoded() {
        try {
            return this.signerAlgorithmIdentifier.getEncoded();
        }
        catch (IOException e) {
            return null;
        }
    }
}

