/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.x509.internal;

import java.security.GeneralSecurityException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.crypto.internal.UserDocumentUtils;
import org.xwiki.crypto.passwd.PasswordCryptoService;
import org.xwiki.crypto.x509.X509CryptoService;
import org.xwiki.crypto.x509.XWikiX509Certificate;
import org.xwiki.crypto.x509.XWikiX509KeyPair;
import org.xwiki.crypto.x509.internal.DefaultXWikiX509KeyPair;
import org.xwiki.crypto.x509.internal.X509KeyService;
import org.xwiki.crypto.x509.internal.X509SignatureService;

@Component
@Singleton
public class DefaultX509CryptoService
implements X509CryptoService {
    @Inject
    private UserDocumentUtils userDocUtils;
    @Inject
    private PasswordCryptoService passwordCryptoService;
    private final X509KeyService keyService = new X509KeyService();
    private final X509SignatureService signatureService = new X509SignatureService();

    @Override
    public XWikiX509Certificate[] certsFromSpkac(String spkacSerialization, int daysOfValidity) throws GeneralSecurityException {
        String userName = this.userDocUtils.getCurrentUser();
        String webID = this.userDocUtils.getUserDocURL(userName);
        return this.keyService.certsFromSpkac(spkacSerialization, daysOfValidity, webID, userName);
    }

    @Override
    public XWikiX509KeyPair newCertAndPrivateKey(int daysOfValidity, String password) throws GeneralSecurityException {
        String userName = this.userDocUtils.getCurrentUser();
        String webID = this.userDocUtils.getUserDocURL(userName);
        return this.keyService.newCertAndPrivateKey(daysOfValidity, webID, userName, password, this.passwordCryptoService);
    }

    @Override
    public String signText(String textToSign, XWikiX509KeyPair toSignWith, String password) throws GeneralSecurityException {
        return this.signatureService.signText(textToSign, toSignWith, password);
    }

    @Override
    public XWikiX509Certificate verifyText(String signedText, String base64Signature) throws GeneralSecurityException {
        return this.signatureService.verifyText(signedText, base64Signature);
    }

    @Override
    public XWikiX509Certificate certFromPEM(String pemFormatCert) throws GeneralSecurityException {
        return XWikiX509Certificate.fromPEMString(pemFormatCert);
    }

    @Override
    public XWikiX509KeyPair keyPairFromBase64(String keyPairAsBase64) throws GeneralSecurityException {
        try {
            return DefaultXWikiX509KeyPair.fromBase64String(keyPairAsBase64);
        }
        catch (Exception e) {
            throw new GeneralSecurityException("Failed to deserialize key pair", e);
        }
    }
}

