/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.passwd.internal;

import java.io.IOException;
import java.security.GeneralSecurityException;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.xwiki.crypto.internal.Convert;
import org.xwiki.crypto.internal.SerializationUtils;
import org.xwiki.crypto.passwd.KeyDerivationFunction;
import org.xwiki.crypto.passwd.PasswordCiphertext;

public abstract class AbstractPasswordCiphertext
implements PasswordCiphertext {
    private static final long serialVersionUID = 1L;
    private byte[] ciphertext;
    private KeyDerivationFunction keyFunction;
    private transient PaddedBufferedBlockCipher cipher;

    @Override
    public synchronized void init(byte[] message, String password, KeyDerivationFunction initializedKeyFunction) throws GeneralSecurityException {
        this.keyFunction = initializedKeyFunction;
        PaddedBufferedBlockCipher theCipher = this.getCipher();
        theCipher.reset();
        theCipher.init(true, this.makeKey(password));
        try {
            this.ciphertext = new byte[theCipher.getOutputSize(message.length)];
            int length = theCipher.processBytes(message, 0, message.length, this.ciphertext, 0);
            theCipher.doFinal(this.ciphertext, length);
        }
        catch (InvalidCipherTextException e) {
            throw new GeneralSecurityException("Failed to encrypt text", e);
        }
    }

    @Override
    public synchronized byte[] decrypt(String password) throws GeneralSecurityException {
        PaddedBufferedBlockCipher theCipher = this.getCipher();
        theCipher.reset();
        theCipher.init(false, this.makeKey(password));
        try {
            byte[] out = new byte[theCipher.getOutputSize(this.ciphertext.length)];
            int length = theCipher.processBytes(this.ciphertext, 0, this.ciphertext.length, out, 0);
            int remaining = theCipher.doFinal(out, length);
            byte[] unpadded = new byte[length + remaining];
            System.arraycopy(out, 0, unpadded, 0, unpadded.length);
            return unpadded;
        }
        catch (InvalidCipherTextException e) {
            return null;
        }
    }

    private synchronized CipherParameters makeKey(String password) {
        byte[] passbytes = Convert.stringToBytes(password);
        byte[] key = new byte[this.getKeyLength()];
        byte[] iv = new byte[this.getCipher().getBlockSize()];
        byte[] keyAndIV = this.keyFunction.deriveKey(passbytes);
        System.arraycopy(keyAndIV, 0, key, 0, key.length);
        System.arraycopy(keyAndIV, key.length, iv, 0, iv.length);
        return new ParametersWithIV((CipherParameters)new KeyParameter(key), iv);
    }

    @Override
    public byte[] serialize() throws IOException {
        return SerializationUtils.serialize(this);
    }

    @Override
    public int getRequiredKeySize() {
        return this.getKeyLength() + this.getCipher().getBlockSize();
    }

    protected int getKeyLength() {
        return 16;
    }

    protected PaddedBufferedBlockCipher getCipher() {
        if (this.cipher == null) {
            this.cipher = this.newCipherInstance();
        }
        return this.cipher;
    }

    protected abstract PaddedBufferedBlockCipher newCipherInstance();
}

