/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.passwd.internal;

import java.io.IOException;
import java.util.Arrays;
import org.xwiki.crypto.internal.SerializationUtils;
import org.xwiki.crypto.passwd.KeyDerivationFunction;
import org.xwiki.crypto.passwd.PasswordVerificationFunction;

public class DefaultPasswordVerificationFunction
implements PasswordVerificationFunction {
    private static final long serialVersionUID = 1L;
    private byte[] passwordHash;
    private KeyDerivationFunction underlyingHashFunction;

    @Override
    public void init(KeyDerivationFunction underlyingHashFunction, byte[] password) {
        this.underlyingHashFunction = underlyingHashFunction;
        this.passwordHash = this.underlyingHashFunction.deriveKey(password);
    }

    @Override
    public byte[] serialize() throws IOException {
        return SerializationUtils.serialize(this);
    }

    @Override
    public boolean isPasswordCorrect(byte[] password) {
        return Arrays.equals(this.passwordHash, this.underlyingHashFunction.deriveKey(password));
    }
}

