/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.passwd.internal;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.xwiki.crypto.passwd.internal.AbstractKeyDerivationFunction;

public class PBKDF2KeyDerivationFunction
extends AbstractKeyDerivationFunction {
    private static final long serialVersionUID = 1L;
    private int iterationCount;
    private int derivedKeyLength;
    private byte[] salt;
    private final String digestClassName;
    private transient byte[] state;
    private transient Mac hMac;

    public PBKDF2KeyDerivationFunction() {
        this((Digest)new SHA1Digest());
    }

    public PBKDF2KeyDerivationFunction(Digest hash) {
        this.digestClassName = hash.getClass().getName();
        this.hMac = new HMac(hash);
        this.state = new byte[this.hMac.getMacSize()];
    }

    @Override
    public void init(byte[] salt, int iterationCount, int derivedKeyLength) {
        this.salt = salt;
        this.iterationCount = iterationCount;
        this.derivedKeyLength = derivedKeyLength;
    }

    @Override
    public synchronized byte[] deriveKey(byte[] password) {
        return this.generateDerivedKey(password, this.salt, this.iterationCount, this.derivedKeyLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized byte[] generateDerivedKey(byte[] password, byte[] salt, int iterationCount, int derivedKeyLength) {
        if (this.hMac == null) {
            try {
                this.hMac = new HMac((Digest)Class.forName(this.digestClassName).newInstance());
                this.state = new byte[this.hMac.getMacSize()];
            }
            catch (Exception e) {
                throw new RuntimeException("Apparently this object was serialized when a digest (" + this.digestClassName + ") was available which is not available now.", e);
            }
        }
        try {
            int hLen = this.hMac.getMacSize();
            int numberOfBlocks = (derivedKeyLength + hLen - 1) / hLen;
            byte[] currentIterationAsByteArray = new byte[4];
            byte[] key = new byte[numberOfBlocks * hLen];
            for (int i = 1; i <= numberOfBlocks; ++i) {
                this.integerToByteArray(i, currentIterationAsByteArray);
                this.functionF(password, salt, iterationCount, currentIterationAsByteArray, key, (i - 1) * hLen);
            }
            byte[] out = new byte[derivedKeyLength];
            System.arraycopy(key, 0, out, 0, derivedKeyLength);
            byte[] byArray = out;
            return byArray;
        }
        finally {
            System.arraycopy(new byte[this.state.length], 0, this.state, 0, this.state.length);
        }
    }

    protected void integerToByteArray(int integer, byte[] outArray) {
        outArray[0] = (byte)(integer >>> 24);
        outArray[1] = (byte)(integer >>> 16);
        outArray[2] = (byte)(integer >>> 8);
        outArray[3] = (byte)integer;
    }

    protected synchronized void functionF(byte[] password, byte[] salt, int iterationCount, byte[] currentIteration, byte[] out, int outOffset) {
        KeyParameter passwordParam = new KeyParameter(password);
        this.hMac.init((CipherParameters)passwordParam);
        if (salt != null) {
            this.hMac.update(salt, 0, salt.length);
        }
        this.hMac.update(currentIteration, 0, currentIteration.length);
        this.hMac.doFinal(this.state, 0);
        System.arraycopy(this.state, 0, out, outOffset, this.state.length);
        if (iterationCount < 1) {
            throw new IllegalArgumentException("iteration count must be at least 1.");
        }
        for (int i = 1; i < iterationCount; ++i) {
            this.hMac.init((CipherParameters)passwordParam);
            this.hMac.update(this.state, 0, this.state.length);
            this.hMac.doFinal(this.state, 0);
            for (int j = 0; j < this.state.length; ++j) {
                int n = outOffset + j;
                out[n] = (byte)(out[n] ^ this.state[j]);
            }
        }
    }
}

