/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.passwd.internal;

import java.security.SecureRandom;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.xwiki.crypto.passwd.internal.AbstractMemoryHardKeyDerivationFunction;
import org.xwiki.crypto.passwd.internal.PBKDF2KeyDerivationFunction;

public class ScryptMemoryHardKeyDerivationFunction
extends AbstractMemoryHardKeyDerivationFunction {
    private static final long serialVersionUID = 1L;
    private int memoryExpense;
    private int processorExpense;
    private int derivedKeyLength;
    private byte[] salt;
    private int blockSize = 8;
    private transient byte[] memoryIntensiveBuffer;
    private transient byte[] blockMixBufferX;
    private transient byte[] blockMixBufferY;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(int kilobytesOfMemoryToUse, int millisecondsOfProcessorTimeToSpend, int derivedKeyLength) {
        int memoryCost;
        if (kilobytesOfMemoryToUse < 0 || millisecondsOfProcessorTimeToSpend < 0 || derivedKeyLength < 1) {
            throw new IllegalArgumentException("All arguments must be positive and derivedKeyLength must be at least 1 byte long");
        }
        this.salt = new byte[16];
        new SecureRandom().nextBytes(this.salt);
        for (memoryCost = 1; memoryCost < kilobytesOfMemoryToUse; memoryCost <<= 1) {
        }
        int distanceToNext = memoryCost - kilobytesOfMemoryToUse;
        int distanceFromLast = kilobytesOfMemoryToUse - (memoryCost >> 1);
        this.memoryExpense = distanceToNext < distanceFromLast ? memoryCost : memoryCost >> 1;
        this.blockSize = 8;
        this.derivedKeyLength = derivedKeyLength;
        int numTrialRuns = 64;
        try {
            long time;
            this.allocateMemory(true);
            byte[] testArray = new byte[1024];
            long timeSpent = 0L;
            do {
                numTrialRuns *= 2;
                time = System.currentTimeMillis();
                for (int i = 0; i < numTrialRuns; ++i) {
                    this.blockMix(testArray);
                }
            } while ((timeSpent = System.currentTimeMillis() - time) <= 20L);
            int totalBlockMixRuns = 2 * this.memoryExpense;
            double timeCostPerCycle = (double)((long)totalBlockMixRuns * timeSpent) / (double)numTrialRuns;
            this.processorExpense = (int)((double)millisecondsOfProcessorTimeToSpend / timeCostPerCycle);
            if (this.processorExpense < 1) {
                this.processorExpense = 1;
            }
        }
        finally {
            this.freeMemory();
        }
    }

    public void init(byte[] salt, int memoryExpense, int blockSize, int processorExpense, int derivedKeyLength) {
        if ((memoryExpense & memoryExpense - 1) != 0 || memoryExpense < 1) {
            throw new IllegalArgumentException("memoryExpense must be a power of 2");
        }
        if (blockSize < 1 || processorExpense < 1 || derivedKeyLength < 1) {
            throw new IllegalArgumentException("blockSize, processorExpense and derivedKeyLength must be positive.");
        }
        if (blockSize * processorExpense > 0x40000000) {
            throw new IllegalArgumentException("(blockSize * processorExpense) must be less than 2^30");
        }
        this.memoryExpense = memoryExpense;
        this.blockSize = blockSize;
        this.processorExpense = processorExpense;
        this.derivedKeyLength = derivedKeyLength;
        this.salt = new byte[salt.length];
        System.arraycopy(salt, 0, this.salt, 0, salt.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] deriveKey(byte[] password) {
        try {
            this.allocateMemory(true);
            PBKDF2KeyDerivationFunction sha256Pbkdf2 = new PBKDF2KeyDerivationFunction((Digest)new SHA256Digest());
            int blockSizeInBytes = 128 * this.blockSize;
            int bufferBLength = blockSizeInBytes * this.processorExpense;
            byte[] workingBufferB = sha256Pbkdf2.generateDerivedKey(password, this.salt, 1, bufferBLength);
            for (int i = 0; i < workingBufferB.length; i += blockSizeInBytes) {
                this.smix(workingBufferB, i);
            }
            byte[] byArray = sha256Pbkdf2.generateDerivedKey(password, workingBufferB, 1, this.derivedKeyLength);
            return byArray;
        }
        finally {
            this.freeMemory();
        }
    }

    protected void allocateMemory(boolean forReal) {
        try {
            this.memoryIntensiveBuffer = new byte[128 * this.blockSize * this.memoryExpense];
            this.blockMixBufferX = new byte[64];
            this.blockMixBufferY = new byte[128 * this.blockSize];
        }
        catch (OutOfMemoryError e) {
            this.freeMemory();
            int memoryToAllocate = 128 * this.blockSize * this.processorExpense;
            memoryToAllocate += 256 * this.blockSize;
            throw new IllegalArgumentException("Cannot allocate " + (memoryToAllocate += 128 * this.blockSize * this.memoryExpense) / 0x100000 + "MB of memory " + "only " + Runtime.getRuntime().freeMemory() / 0x100000L + "MB of memory are available.");
        }
        if (!forReal) {
            this.freeMemory();
        }
    }

    protected void freeMemory() {
        this.memoryIntensiveBuffer = null;
        this.blockMixBufferX = null;
        this.blockMixBufferY = null;
    }

    protected void smix(byte[] bufferToMix, int offset) {
        int i;
        int lengthToMix = 128 * this.blockSize;
        byte[] bufferX = new byte[lengthToMix];
        System.arraycopy(bufferToMix, offset, bufferX, 0, lengthToMix);
        for (i = 0; i < this.memoryExpense; ++i) {
            System.arraycopy(bufferX, 0, this.memoryIntensiveBuffer, i * lengthToMix, lengthToMix);
            this.blockMix(bufferX);
        }
        for (i = 0; i < this.memoryExpense; ++i) {
            int blockToXOR = this.integerifyAndMod(bufferX, this.memoryExpense);
            this.bulkXOR(this.memoryIntensiveBuffer, blockToXOR * lengthToMix, bufferX, 0, lengthToMix);
            this.blockMix(bufferX);
        }
        System.arraycopy(bufferX, 0, bufferToMix, offset, lengthToMix);
    }

    protected void blockMix(byte[] block) {
        int i;
        System.arraycopy(block, block.length - 64, this.blockMixBufferX, 0, 64);
        for (i = 0; i < block.length; i += 64) {
            this.bulkXOR(block, i, this.blockMixBufferX, 0, 64);
            this.scryptSalsa8(this.blockMixBufferX);
            System.arraycopy(this.blockMixBufferX, 0, this.blockMixBufferY, i, 64);
        }
        for (i = 0; i < this.blockSize; ++i) {
            System.arraycopy(this.blockMixBufferY, i * 2 * 64, block, i * 64, 64);
        }
        for (i = 0; i < this.blockSize; ++i) {
            System.arraycopy(this.blockMixBufferY, (i * 2 + 1) * 64, block, (i + this.blockSize) * 64, 64);
        }
    }

    protected int integerifyAndMod(byte[] array, int modulus) {
        return this.unsignedMod(this.integerify(array), modulus);
    }

    protected long integerify(byte[] array) {
        int startIndex = (2 * this.blockSize - 1) * 64;
        int endIndex = startIndex + 3;
        long fromArray = 0L;
        for (int i = endIndex; i >= startIndex; --i) {
            fromArray <<= 8;
            fromArray |= (long)(array[i] & 0xFF);
        }
        return fromArray;
    }

    protected int unsignedMod(long unsignedLong, int signedModulus) {
        return (int)(unsignedLong & (long)signedModulus - 1L);
    }

    protected void bulkXOR(byte[] input, int inputOffset, byte[] output, int outputOffset, int length) {
        for (int i = 0; i < length; ++i) {
            int n = i + outputOffset;
            output[n] = (byte)(output[n] ^ input[i + inputOffset]);
        }
    }

    protected void scryptSalsa8(byte[] bytesToModify) {
        int[] inputAsInts = new int[16];
        this.bytesToIntsLittle(bytesToModify, inputAsInts);
        int[] workingBuffer = new int[16];
        this.salsa20Core(inputAsInts, workingBuffer, 8);
        this.intsToBytesLittle(workingBuffer, bytesToModify);
    }

    protected void salsa20Core(int[] input, int[] output, int numberOfRounds) {
        int i;
        System.arraycopy(input, 0, output, 0, 16);
        for (i = numberOfRounds; i > 0; i -= 2) {
            this.salsa20ColumnHalfround(output);
            this.salsa20RowHalfround(output);
        }
        for (i = 0; i < 16; ++i) {
            output[i] = output[i] + input[i];
        }
    }

    private void salsa20ColumnHalfround(int[] workBuffer) {
        workBuffer[4] = workBuffer[4] ^ this.rotl(workBuffer[0] + workBuffer[12], 7);
        workBuffer[8] = workBuffer[8] ^ this.rotl(workBuffer[4] + workBuffer[0], 9);
        workBuffer[12] = workBuffer[12] ^ this.rotl(workBuffer[8] + workBuffer[4], 13);
        workBuffer[0] = workBuffer[0] ^ this.rotl(workBuffer[12] + workBuffer[8], 18);
        workBuffer[9] = workBuffer[9] ^ this.rotl(workBuffer[5] + workBuffer[1], 7);
        workBuffer[13] = workBuffer[13] ^ this.rotl(workBuffer[9] + workBuffer[5], 9);
        workBuffer[1] = workBuffer[1] ^ this.rotl(workBuffer[13] + workBuffer[9], 13);
        workBuffer[5] = workBuffer[5] ^ this.rotl(workBuffer[1] + workBuffer[13], 18);
        workBuffer[14] = workBuffer[14] ^ this.rotl(workBuffer[10] + workBuffer[6], 7);
        workBuffer[2] = workBuffer[2] ^ this.rotl(workBuffer[14] + workBuffer[10], 9);
        workBuffer[6] = workBuffer[6] ^ this.rotl(workBuffer[2] + workBuffer[14], 13);
        workBuffer[10] = workBuffer[10] ^ this.rotl(workBuffer[6] + workBuffer[2], 18);
        workBuffer[3] = workBuffer[3] ^ this.rotl(workBuffer[15] + workBuffer[11], 7);
        workBuffer[7] = workBuffer[7] ^ this.rotl(workBuffer[3] + workBuffer[15], 9);
        workBuffer[11] = workBuffer[11] ^ this.rotl(workBuffer[7] + workBuffer[3], 13);
        workBuffer[15] = workBuffer[15] ^ this.rotl(workBuffer[11] + workBuffer[7], 18);
    }

    private void salsa20RowHalfround(int[] workBuffer) {
        workBuffer[1] = workBuffer[1] ^ this.rotl(workBuffer[0] + workBuffer[3], 7);
        workBuffer[2] = workBuffer[2] ^ this.rotl(workBuffer[1] + workBuffer[0], 9);
        workBuffer[3] = workBuffer[3] ^ this.rotl(workBuffer[2] + workBuffer[1], 13);
        workBuffer[0] = workBuffer[0] ^ this.rotl(workBuffer[3] + workBuffer[2], 18);
        workBuffer[6] = workBuffer[6] ^ this.rotl(workBuffer[5] + workBuffer[4], 7);
        workBuffer[7] = workBuffer[7] ^ this.rotl(workBuffer[6] + workBuffer[5], 9);
        workBuffer[4] = workBuffer[4] ^ this.rotl(workBuffer[7] + workBuffer[6], 13);
        workBuffer[5] = workBuffer[5] ^ this.rotl(workBuffer[4] + workBuffer[7], 18);
        workBuffer[11] = workBuffer[11] ^ this.rotl(workBuffer[10] + workBuffer[9], 7);
        workBuffer[8] = workBuffer[8] ^ this.rotl(workBuffer[11] + workBuffer[10], 9);
        workBuffer[9] = workBuffer[9] ^ this.rotl(workBuffer[8] + workBuffer[11], 13);
        workBuffer[10] = workBuffer[10] ^ this.rotl(workBuffer[9] + workBuffer[8], 18);
        workBuffer[12] = workBuffer[12] ^ this.rotl(workBuffer[15] + workBuffer[14], 7);
        workBuffer[13] = workBuffer[13] ^ this.rotl(workBuffer[12] + workBuffer[15], 9);
        workBuffer[14] = workBuffer[14] ^ this.rotl(workBuffer[13] + workBuffer[12], 13);
        workBuffer[15] = workBuffer[15] ^ this.rotl(workBuffer[14] + workBuffer[13], 18);
    }

    protected int rotl(int x, int y) {
        return x << y | x >>> -y;
    }

    protected void intsToBytesLittle(int[] input, byte[] output) {
        int outCounter = 0;
        for (int i = 0; i < input.length; ++i) {
            output[outCounter] = (byte)input[i];
            output[outCounter + 1] = (byte)(input[i] >>> 8);
            output[outCounter + 2] = (byte)(input[i] >>> 16);
            output[outCounter + 3] = (byte)(input[i] >>> 24);
            outCounter += 4;
        }
    }

    protected void bytesToIntsLittle(byte[] input, int[] output) {
        int outCounter = 0;
        for (int i = 0; i < input.length; i += 4) {
            output[outCounter] = input[i] & 0xFF;
            int n = outCounter;
            output[n] = output[n] | (input[i + 1] & 0xFF) << 8;
            int n2 = outCounter;
            output[n2] = output[n2] | (input[i + 2] & 0xFF) << 16;
            int n3 = outCounter++;
            output[n3] = output[n3] | input[i + 3] << 24;
        }
    }
}

