/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.x509.internal;

import java.security.GeneralSecurityException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSSignedGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.xwiki.crypto.internal.Convert;
import org.xwiki.crypto.x509.XWikiX509Certificate;
import org.xwiki.crypto.x509.XWikiX509KeyPair;

public class X509SignatureService {
    private static final String DIGEST_OID = CMSSignedGenerator.DIGEST_SHA1;
    private static final String PROVIDER = "BC";
    private static final String CERT_STORE_TYPE = "Collection";

    public String signText(String textToSign, XWikiX509KeyPair toSignWith, String password) throws GeneralSecurityException {
        XWikiX509Certificate certificate = toSignWith.getCertificate();
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        Set<XWikiX509Certificate> certs = Collections.singleton(certificate);
        CertStore store = CertStore.getInstance(CERT_STORE_TYPE, new CollectionCertStoreParameters(certs));
        try {
            gen.addCertificatesAndCRLs(store);
            gen.addSigner(toSignWith.getPrivateKey(password), (X509Certificate)certificate, DIGEST_OID);
            byte[] data = textToSign.getBytes();
            CMSSignedData cmsData = gen.generate((CMSProcessable)new CMSProcessableByteArray(data), false, PROVIDER);
            return Convert.toBase64String(cmsData.getEncoded());
        }
        catch (GeneralSecurityException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new GeneralSecurityException(exception);
        }
    }

    public XWikiX509Certificate verifyText(String signedText, String base64Signature) throws GeneralSecurityException {
        try {
            byte[] data = signedText.getBytes();
            byte[] signature = Convert.fromBase64String(base64Signature);
            CMSSignedData cmsData = new CMSSignedData((CMSProcessable)new CMSProcessableByteArray(data), signature);
            CertStore certStore = cmsData.getCertificatesAndCRLs(CERT_STORE_TYPE, PROVIDER);
            SignerInformationStore signers = cmsData.getSignerInfos();
            int numSigners = signers.getSigners().size();
            if (numSigners != 1) {
                throw new GeneralSecurityException("Only one signature is supported, found " + numSigners);
            }
            XWikiX509Certificate result = null;
            Iterator it = signers.getSigners().iterator();
            while (it.hasNext()) {
                if (result != null) {
                    throw new GeneralSecurityException("Only one certificate is supported");
                }
                SignerInformation signer = (SignerInformation)it.next();
                Collection<? extends Certificate> certs = certStore.getCertificates((CertSelector)signer.getSID());
                for (Certificate certificate : certs) {
                    if (!signer.verify(certificate.getPublicKey(), PROVIDER)) {
                        return null;
                    }
                    if (!(certificate instanceof X509Certificate)) continue;
                    result = new XWikiX509Certificate((X509Certificate)certificate, null);
                }
            }
            return result;
        }
        catch (CMSException exception) {
            if ("message-digest attribute value does not match calculated value".equals(exception.getMessage())) {
                return null;
            }
            throw new GeneralSecurityException(exception);
        }
        catch (Exception exception) {
            throw new GeneralSecurityException(exception);
        }
    }
}

