/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.csrf.internal;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.container.Container;
import org.xwiki.container.Request;
import org.xwiki.container.servlet.ServletRequest;
import org.xwiki.container.servlet.filters.SavedRequestManager;
import org.xwiki.csrf.CSRFToken;
import org.xwiki.csrf.CSRFTokenConfiguration;
import org.xwiki.model.reference.DocumentReference;

@Component
@Singleton
public class DefaultCSRFToken
implements CSRFToken,
Initializable {
    private static final int TOKEN_LENGTH = 16;
    private static final String RESUBMIT_TEMPLATE = "resubmit";
    private final ConcurrentMap<String, String> tokens = new ConcurrentHashMap<String, String>();
    private SecureRandom random;
    @Inject
    private DocumentAccessBridge docBridge;
    @Inject
    private Container container;
    @Inject
    private CSRFTokenConfiguration configuration;
    @Inject
    private Logger logger;

    public void initialize() throws InitializationException {
        try {
            this.random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            this.random = new SecureRandom();
            this.logger.warn("CSRFToken: Using default implementation of SecureRandom");
        }
        byte[] seed = this.random.generateSeed(16);
        this.random.setSeed(seed);
        this.logger.debug("CSRFToken: Anti-CSRF secret token component has been initialized");
    }

    protected void setRandom(SecureRandom random) {
        this.random = random;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getToken() {
        String key = this.getTokenKey();
        String token = (String)this.tokens.get(key);
        if (token != null) {
            return token;
        }
        ConcurrentMap<String, String> concurrentMap = this.tokens;
        synchronized (concurrentMap) {
            if (!this.tokens.containsKey(key)) {
                byte[] bytes = new byte[16];
                this.random.nextBytes(bytes);
                token = Base64.encodeBase64URLSafeString((byte[])bytes).replaceAll("[_=+-]", "x");
                this.tokens.put(key, token);
            }
            return (String)this.tokens.get(key);
        }
    }

    @Override
    public void clearToken() {
        this.logger.debug("Forgetting CSRF token for [{}]", (Object)this.getTokenKey());
        this.tokens.remove(this.getTokenKey());
    }

    @Override
    public boolean isTokenValid(String token) {
        if (!this.configuration.isEnabled()) {
            return true;
        }
        String storedToken = this.getToken();
        if (token == null || token.equals("") || !storedToken.equals(token)) {
            this.logger.warn("CSRFToken: Secret token verification failed, token: \"" + token + "\", stored token: \"" + storedToken + "\"");
            return false;
        }
        return true;
    }

    @Override
    public String getResubmissionURL() {
        String srid = SavedRequestManager.saveRequest((HttpServletRequest)this.getRequest());
        String resubmitUrl = this.getRequest().getRequestURI();
        resubmitUrl = resubmitUrl + '?' + SavedRequestManager.getSavedRequestIdentifier() + "=" + srid;
        String query = "resubmit=" + this.urlEncode(resubmitUrl);
        String backUrl = this.getDocumentURL(this.docBridge.getCurrentDocumentReference(), null);
        query = query + "&xback=" + this.urlEncode(backUrl);
        query = query + "&xpage=resubmit";
        return backUrl + "?" + query;
    }

    private String getDocumentURL(DocumentReference reference, String query) {
        return this.docBridge.getDocumentURL(reference, "view", query, null);
    }

    private String urlEncode(String str) {
        String encoding = "UTF-8";
        try {
            return URLEncoder.encode(str, encoding);
        }
        catch (UnsupportedEncodingException exception) {
            return "";
        }
    }

    private HttpServletRequest getRequest() {
        Request request = this.container.getRequest();
        if (request instanceof ServletRequest) {
            return ((ServletRequest)request).getHttpServletRequest();
        }
        throw new RuntimeException("Not supported request type");
    }

    private String getTokenKey() {
        return this.docBridge.getCurrentUser();
    }
}

